/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.targetlink;

import java.io.StringReader;
import org.conqat.lib.commons.visitor.IVisitor;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkObject;
import org.conqat.lib.simulink.targetlink.TargetLinkUtils;
import org.conqat.lib.simulink.targetlink.TargetlinkDataParser;
import org.conqat.lib.simulink.targetlink.TargetlinkDataScanner;
import org.conqat.lib.simulink.targetlink.TargetlinkStruct;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class TargetLinkDataResolver
implements IVisitor<SimulinkBlock, SimulinkModelBuildingException> {
    public static final String PARAMETER_SEPARATOR = "/";

    public void visit(SimulinkBlock block) throws SimulinkModelBuildingException {
        if (TargetLinkUtils.isTargetlinkBlock(block)) {
            TargetLinkDataResolver.unfoldTargetlinkData(block);
        }
    }

    private static void unfoldTargetlinkData(SimulinkBlock block) throws SimulinkModelBuildingException {
        String data = TargetLinkDataResolver.extractTargetlinkData(block);
        if (data == null || "off".equals(data)) {
            return;
        }
        TargetlinkStruct struct = TargetLinkDataResolver.parseTargetlinkData(block, data);
        struct.getParameters().forEach((key, value) -> block.setParameter("data" + key, (String)value));
    }

    private static String extractTargetlinkData(SimulinkBlock block) {
        String maskValueString;
        SimulinkObject maskObject = SimulinkUtils.findObjectByClass(block, "Simulink.Mask");
        SimulinkObject maskParameterObject = SimulinkUtils.findObjectByClass(maskObject, "Simulink.MaskParameter");
        if (maskParameterObject != null && "data".equals(maskParameterObject.getName())) {
            return maskParameterObject.getParameter("Value");
        }
        if (TargetLinkUtils.isTargetlinkMaskType(block) && (maskValueString = block.getParameter("MaskValueString")) != null) {
            return maskValueString.split("[|]", 2)[0];
        }
        String slxMaskData = block.getParameter("Mask.MaskParameter.Value");
        if (slxMaskData != null) {
            return slxMaskData;
        }
        return block.getParameter("data");
    }

    private static TargetlinkStruct parseTargetlinkData(SimulinkBlock block, String data) throws SimulinkModelBuildingException {
        TargetlinkDataScanner scanner = new TargetlinkDataScanner(new StringReader(data));
        TargetlinkDataParser parser = new TargetlinkDataParser(scanner);
        try {
            return (TargetlinkStruct)parser.parse().value;
        }
        catch (Exception ex) {
            throw new SimulinkModelBuildingException(String.valueOf(ex) + " in block " + block.getId(), ex);
        }
    }
}

