/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.ECommitStatus;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.jspecify.annotations.Nullable;

class CompactFormatBranchCommitInfo
implements IBranchCommitInfo {
    private final byte[] commitName;
    private final byte[] commitNameForKeys;
    private final byte[] parentCommitName;
    private final byte[] deltaPredecessorCommitName;
    private final byte[][] allDeltaPredecessorCommitNamesForDataKeys;
    private final int depth;
    private final ECommitStatus status;

    public CompactFormatBranchCommitInfo(byte[] commitName, byte[] commitNameForKeys, byte[] parentCommitName, byte[] deltaPredecessorCommitName, byte[][] allDeltaPredecessorCommitNamesForDataKeys, int depth, ECommitStatus status) {
        this.commitName = commitName;
        this.commitNameForKeys = commitNameForKeys;
        this.parentCommitName = parentCommitName;
        this.deltaPredecessorCommitName = deltaPredecessorCommitName;
        this.allDeltaPredecessorCommitNamesForDataKeys = allDeltaPredecessorCommitNamesForDataKeys;
        this.depth = depth;
        this.status = status;
    }

    private CompactFormatBranchCommitInfo(CompactFormatBranchCommitInfo other, ECommitStatus newStatus) {
        this.commitName = other.commitName;
        this.commitNameForKeys = other.commitNameForKeys;
        this.parentCommitName = other.parentCommitName;
        this.deltaPredecessorCommitName = other.deltaPredecessorCommitName;
        this.allDeltaPredecessorCommitNamesForDataKeys = other.allDeltaPredecessorCommitNamesForDataKeys;
        this.depth = other.depth;
        this.status = newStatus;
    }

    @Override
    public byte[] getCommitName() {
        return this.commitName;
    }

    @Override
    public byte[] getParentCommitName() {
        return this.parentCommitName;
    }

    @Override
    public ECommitStatus getStatus() {
        return this.status;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public IBranchCommitInfo cloneWithNewStatus(ECommitStatus newStatus) {
        return new CompactFormatBranchCommitInfo(this, newStatus);
    }

    @Override
    public byte[] getCommitNameForDataKeys() {
        return this.commitNameForKeys;
    }

    @Override
    public byte[] getDeltaPredecessorCommitName() {
        return this.deltaPredecessorCommitName;
    }

    @Override
    public byte[] @Nullable [] getAllDeltaPredecessorCommitNamesForDataKeys() {
        return this.allDeltaPredecessorCommitNamesForDataKeys;
    }

    @Override
    public byte[] serializeToBytes() throws StorageException {
        byte[] throwable;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        try {
            CompactFormatBranchCommitInfo.writeNullable(this.commitName, bao);
            CompactFormatBranchCommitInfo.writeAbbreviated(this.commitNameForKeys, bao);
            CompactFormatBranchCommitInfo.writeNullable(this.parentCommitName, bao);
            CompactFormatBranchCommitInfo.writeNullable(this.deltaPredecessorCommitName, bao);
            if (this.allDeltaPredecessorCommitNamesForDataKeys == null) {
                bao.write(ByteArrayUtils.intToByteArray((int)0));
            } else {
                bao.write(ByteArrayUtils.intToByteArray((int)this.allDeltaPredecessorCommitNamesForDataKeys.length));
                for (byte[] name : this.allDeltaPredecessorCommitNamesForDataKeys) {
                    CompactFormatBranchCommitInfo.writeAbbreviated(name, bao);
                }
            }
            bao.write(ByteArrayUtils.intToByteArray((int)this.depth));
            bao.write(this.status.ordinal());
            throwable = bao.toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    bao.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
        bao.close();
        return throwable;
    }

    private static void writeAbbreviated(byte[] name, ByteArrayOutputStream bao) throws IOException {
        CCSMAssert.isTrue((name.length == 4 ? 1 : 0) != 0, (String)"Expecting short keys to encode integers!");
        bao.write(name);
    }

    private static void writeNullable(byte[] nullable, ByteArrayOutputStream bao) throws IOException {
        if (nullable == null) {
            bao.write(ByteArrayUtils.intToByteArray((int)0));
        } else {
            bao.write(ByteArrayUtils.intToByteArray((int)nullable.length));
            bao.write(nullable);
        }
    }
}

