/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageAbbreviation;
import org.conqat.engine.persistence.store.util.StorageAbbreviationList;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

public interface IStorageAbbreviator {
    default public StorageAbbreviation abbreviate(@NonNull String value) throws StorageException {
        return this.abbreviateAll(List.of(value)).getFirst();
    }

    default public @NonNull Map<@NonNull String, @NonNull StorageAbbreviation> abbreviateAsMap(@NonNull Collection<@NonNull String> values) throws StorageException {
        HashMap<String, StorageAbbreviation> result = HashMap.newHashMap(values.size());
        StorageAbbreviationList abbreviations = this.abbreviateAll(values);
        CollectionUtils.forEach(values, (Iterable)abbreviations, result::put);
        return result;
    }

    public @NonNull StorageAbbreviationList abbreviateAll(@NonNull Collection<@NonNull String> var1) throws StorageException;

    default public @NonNull String unabbreviate(StorageAbbreviation abbreviation) throws StorageException {
        return this.unabbreviateAll(List.of(abbreviation)).getFirst();
    }

    default public @NonNull Map<@NonNull StorageAbbreviation, @NonNull String> unabbreviateAsMap(@NonNull Collection<@NonNull StorageAbbreviation> abbreviations) throws StorageException {
        HashMap<StorageAbbreviation, String> result = HashMap.newHashMap(abbreviations.size());
        List<String> values = this.unabbreviateAll(abbreviations);
        CollectionUtils.forEach(values, abbreviations, (value, abbreviation) -> result.put((StorageAbbreviation)abbreviation, (String)value));
        return result;
    }

    public @NonNull List<@NonNull String> unabbreviateAll(@NonNull Collection<@NonNull StorageAbbreviation> var1) throws StorageException;
}

