/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CommonUtils {
    public static Pattern compilePattern(String regex) throws ConQATException {
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new ConQATException("Illegal regular expression: ", (Throwable)e);
        }
    }

    public static Charset obtainEncoding(String encodingName) throws ConQATException {
        if (!Charset.isSupported(encodingName)) {
            throw new ConQATException("Unsupported encoding: " + encodingName);
        }
        return Charset.forName(encodingName);
    }

    @SafeVarargs
    public static <T> boolean isOneOf(T obj, T ... others) {
        Objects.requireNonNull(others);
        return CommonUtils.isOneOf(obj, Arrays.asList(others));
    }

    public static <T> boolean isOneOf(T obj, Collection<T> others) {
        Objects.requireNonNull(others);
        for (T otherObj : others) {
            if (!Objects.equals(obj, otherObj)) continue;
            return true;
        }
        return false;
    }

    private CommonUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

