/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass(containedInBackup=true)
public class ParentedCommitDescriptor
extends CommitDescriptor {
    private static final long serialVersionUID = 1L;
    private static final String PARENT_COMMITS_PROPERTY = "parentCommits";
    @JsonProperty(value="parentCommits")
    private final List<@NonNull CommitDescriptor> parentCommits = new ArrayList<CommitDescriptor>();

    public ParentedCommitDescriptor(CommitDescriptor commitDescriptor, List<CommitDescriptor> parentCommits) {
        super(commitDescriptor.getBranchName(), commitDescriptor.getTimestamp());
        this.insertParentCommits(parentCommits);
    }

    public ParentedCommitDescriptor(CommitDescriptor commitDescriptor, CommitDescriptor ... parentCommits) {
        this(commitDescriptor, Arrays.asList(parentCommits));
    }

    private void insertParentCommits(List<CommitDescriptor> parentCommits) {
        for (CommitDescriptor parent : parentCommits) {
            CCSMAssert.isTrue((parent.getTimestamp() < this.getTimestamp() ? 1 : 0) != 0, () -> "Can't set newer commit (" + String.valueOf(parent) + ") as parent of older commit (" + String.valueOf(this) + ")");
            this.parentCommits.add(new CommitDescriptor(parent.getBranchName(), parent.getTimestamp()));
        }
    }

    @JsonCreator
    public ParentedCommitDescriptor(@JsonProperty(value="branchName") String branchName, @JsonProperty(value="timestamp") long timestamp, CommitDescriptor ... parentCommits) {
        super(branchName, timestamp);
        this.insertParentCommits(Arrays.asList(parentCommits));
    }

    public static ParentedCommitDescriptor cleanCopyOf(ParentedCommitDescriptor parentedCommitDescriptor) {
        return new ParentedCommitDescriptor(new CommitDescriptor(parentedCommitDescriptor.getBranchName(), parentedCommitDescriptor.getTimestamp()), (List<CommitDescriptor>)parentedCommitDescriptor.getParentCommits());
    }

    public UnmodifiableList<CommitDescriptor> getParentCommits() {
        return CollectionUtils.asUnmodifiable(this.parentCommits);
    }

    public CommitDescriptor getFirstParentCommit() {
        if (this.isStartCommit()) {
            return null;
        }
        return this.parentCommits.getFirst();
    }

    public UnmodifiableList<CommitDescriptor> getOtherParentCommits() {
        if (this.isStartCommit()) {
            return CollectionUtils.asUnmodifiable(Collections.emptyList());
        }
        return CollectionUtils.asUnmodifiable(this.parentCommits.subList(1, this.parentCommits.size()));
    }

    public boolean isMergeCommit() {
        return this.parentCommits.size() > 1;
    }

    public boolean isStartCommit() {
        return this.parentCommits.isEmpty();
    }

    public String toStringWithParents() {
        StringBuilder builder = new StringBuilder();
        builder.append(this);
        this.parentCommits.forEach(parent -> builder.append(" parent:").append(parent));
        return builder.toString();
    }
}

