/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.sonarlint.core.AbstractSonarLintEngine;
import org.sonarsource.sonarlint.core.ServerFileExclusions;
import org.sonarsource.sonarlint.core.analysis.AnalysisEngine;
import org.sonarsource.sonarlint.core.analysis.api.ActiveRule;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisEngineConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisResults;
import org.sonarsource.sonarlint.core.analysis.api.Issue;
import org.sonarsource.sonarlint.core.analysis.command.AnalyzeCommand;
import org.sonarsource.sonarlint.core.analysis.sonarapi.MapSettings;
import org.sonarsource.sonarlint.core.client.api.common.PluginDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.DefaultClientIssue;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedRuleDetails;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.connected.ProjectBranches;
import org.sonarsource.sonarlint.core.client.api.exceptions.SonarLintWrappedException;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.RuleKey;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.VulnerabilityProbability;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;
import org.sonarsource.sonarlint.core.commons.progress.ClientProgressMonitor;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoadResult;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoader;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDefinition;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.component.ServerProject;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspot;
import org.sonarsource.sonarlint.core.serverapi.rules.ServerActiveRule;
import org.sonarsource.sonarlint.core.serverconnection.AnalyzerConfiguration;
import org.sonarsource.sonarlint.core.serverconnection.IssueStorePaths;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBinding;
import org.sonarsource.sonarlint.core.serverconnection.RuleSet;
import org.sonarsource.sonarlint.core.serverconnection.ServerConnection;
import org.sonarsource.sonarlint.core.serverconnection.SynchronizationResult;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerTaintIssue;
import org.sonarsource.sonarlint.core.serverconnection.storage.StorageException;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public final class ConnectedSonarLintEngineImpl
extends AbstractSonarLintEngine
implements ConnectedSonarLintEngine {
    private final ConnectedGlobalConfiguration globalConfig;
    private final ServerConnection serverConnection;
    private final AtomicReference<AnalysisContext> analysisContext = new AtomicReference();

    public ConnectedSonarLintEngineImpl(ConnectedGlobalConfiguration globalConfig) {
        super(globalConfig.getLogOutput());
        this.globalConfig = globalConfig;
        this.serverConnection = new ServerConnection(globalConfig.getStorageRoot(), globalConfig.getConnectionId(), globalConfig.isSonarCloud(), globalConfig.getEnabledLanguages(), globalConfig.getEmbeddedPluginPathsByKey().keySet(), globalConfig.getWorkDir());
        this.start();
    }

    @Override
    public AnalysisEngine getAnalysisEngine() {
        return this.analysisContext.get().analysisEngine;
    }

    public AnalysisContext start() {
        this.setLogging(null);
        return this.analysisContext.getAndSet(this.loadAnalysisContext());
    }

    private AnalysisContext loadAnalysisContext() {
        PluginsLoadResult loadingResult = this.loadPlugins();
        List<PluginDetails> pluginDetails = loadingResult.getPluginCheckResultByKeys().values().stream().map(p -> new PluginDetails(p.getPlugin().getKey(), p.getPlugin().getName(), Optional.ofNullable(p.getPlugin().getVersion()).map(Version::toString).orElse(null), p.getSkipReason().orElse(null))).collect(Collectors.toList());
        Map<String, SonarLintRuleDefinition> allRulesDefinitionsByKey = ConnectedSonarLintEngineImpl.loadPluginMetadata(loadingResult.getLoadedPlugins(), this.globalConfig.getEnabledLanguages(), true, this.globalConfig.isHotspotsEnabled());
        AnalysisEngineConfiguration analysisGlobalConfig = AnalysisEngineConfiguration.builder().setClientPid(this.globalConfig.getClientPid()).setExtraProperties(this.globalConfig.extraProperties()).setNodeJs(this.globalConfig.getNodeJsPath()).setWorkDir(this.globalConfig.getWorkDir()).setModulesProvider(this.globalConfig.getModulesProvider()).build();
        AnalysisEngine analysisEngine = new AnalysisEngine(analysisGlobalConfig, loadingResult.getLoadedPlugins(), this.logOutput);
        return new AnalysisContext(pluginDetails, allRulesDefinitionsByKey, analysisEngine);
    }

    private PluginsLoadResult loadPlugins() {
        HashMap<String, Path> pluginsToLoadByKey = new HashMap<String, Path>();
        pluginsToLoadByKey.putAll(this.serverConnection.getStoredPluginPathsByKey());
        pluginsToLoadByKey.putAll(this.getEmbeddedPluginPathsByKey());
        HashSet<Path> plugins = new HashSet<Path>(pluginsToLoadByKey.values());
        PluginsLoader.Configuration config = new PluginsLoader.Configuration(plugins, this.globalConfig.getEnabledLanguages(), this.globalConfig.isDataflowBugDetectionEnabled(), Optional.ofNullable(this.globalConfig.getNodeJsVersion()));
        return new PluginsLoader().load(config);
    }

    private Map<String, Path> getEmbeddedPluginPathsByKey() {
        if (this.serverConnection.supportsCustomSecrets()) {
            HashMap<String, Path> embeddedPluginsExceptSecrets = new HashMap<String, Path>(this.globalConfig.getEmbeddedPluginPathsByKey());
            embeddedPluginsExceptSecrets.remove(Language.SECRETS.getPluginKey());
            return embeddedPluginsExceptSecrets;
        }
        return this.globalConfig.getEmbeddedPluginPathsByKey();
    }

    @Override
    public AnalysisResults analyze(ConnectedAnalysisConfiguration configuration, IssueListener issueListener, @Nullable ClientLogOutput logOutput, @Nullable ClientProgressMonitor monitor) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(issueListener);
        this.setLogging(logOutput);
        AnalysisConfiguration.Builder analysisConfigBuilder = AnalysisConfiguration.builder().addInputFiles(configuration.inputFiles());
        String projectKey = configuration.getProjectKey();
        analysisConfigBuilder.putAllExtraProperties(this.serverConnection.getAnalyzerConfiguration(projectKey).getSettings().getAll());
        analysisConfigBuilder.putAllExtraProperties(this.globalConfig.extraProperties());
        ActiveRulesContext activeRulesContext = this.buildActiveRulesContext(configuration);
        if (activeRulesContext.activeRules.isEmpty()) {
            LOG.info("Skipping analysis, no synchronization has been made with the server");
            return new AnalysisResults();
        }
        analysisConfigBuilder.putAllExtraProperties(configuration.extraProperties()).addActiveRules(activeRulesContext.activeRules).setBaseDir(configuration.baseDir()).build();
        AnalysisConfiguration analysisConfiguration = analysisConfigBuilder.build();
        AnalyzeCommand analyzeCommand = new AnalyzeCommand(configuration.moduleKey(), analysisConfiguration, issue -> this.streamIssue(issueListener, (Issue)issue, activeRulesContext), logOutput);
        return this.postAnalysisCommandAndGetResult(analyzeCommand, monitor);
    }

    private void streamIssue(IssueListener issueListener, Issue newIssue, ActiveRulesContext activeRulesContext) {
        ActiveRulesContext.ActiveRuleMetadata ruleMetadata = activeRulesContext.getRuleMetadata(newIssue.getRuleKey());
        Optional<VulnerabilityProbability> vulnerabilityProbability = this.analysisContext.get().findRule(newIssue.getRuleKey()).flatMap(SonarLintRuleDefinition::getVulnerabilityProbability);
        CleanCodeAttribute effectiveCleanCodeAttribute = activeRulesContext.shouldSkipCleanCodeTaxonomy ? null : ruleMetadata.cleanCodeAttribute;
        Map<SoftwareQuality, ImpactSeverity> effectiveImpacts = activeRulesContext.shouldSkipCleanCodeTaxonomy ? Map.of() : ruleMetadata.defaultImpacts;
        issueListener.handle(new DefaultClientIssue(newIssue, ruleMetadata.severity, ruleMetadata.type, effectiveCleanCodeAttribute, effectiveImpacts, vulnerabilityProbability));
    }

    private ActiveRulesContext buildActiveRulesContext(ConnectedAnalysisConfiguration configuration) {
        ActiveRulesContext analysisRulesContext = new ActiveRulesContext(this.serverConnection.shouldSkipCleanCodeTaxonomy());
        String projectKey = configuration.getProjectKey();
        Map<String, RuleSet> ruleSetByLanguageKey = this.serverConnection.getAnalyzerConfiguration(projectKey).getRuleSetByLanguageKey();
        if (ruleSetByLanguageKey.isEmpty()) {
            return analysisRulesContext;
        }
        ruleSetByLanguageKey.entrySet().stream().filter(e -> Language.forKey((String)e.getKey()).filter(l -> this.globalConfig.getEnabledLanguages().contains(l)).isPresent()).forEach(e -> {
            String languageKey = (String)e.getKey();
            RuleSet ruleSet = (RuleSet)e.getValue();
            LOG.debug("  * {}: {} active rules", (Object)languageKey, (Object)ruleSet.getRules().size());
            for (ServerActiveRule possiblyDeprecatedActiveRuleFromStorage : ruleSet.getRules()) {
                SonarLintRuleDefinition ruleOrTemplateDefinition;
                ServerActiveRule activeRuleFromStorage = this.tryConvertDeprecatedKeys(possiblyDeprecatedActiveRuleFromStorage);
                if (StringUtils.isNotBlank(activeRuleFromStorage.getTemplateKey())) {
                    ruleOrTemplateDefinition = this.analysisContext.get().findRule(activeRuleFromStorage.getTemplateKey()).orElse(null);
                    if (ruleOrTemplateDefinition == null) {
                        LOG.debug("Rule {} is enabled on the server, but its template {} is not available in SonarLint", (Object)activeRuleFromStorage.getRuleKey(), (Object)activeRuleFromStorage.getTemplateKey());
                        continue;
                    }
                } else {
                    ruleOrTemplateDefinition = this.analysisContext.get().findRule(activeRuleFromStorage.getRuleKey()).orElse(null);
                    if (ruleOrTemplateDefinition == null) {
                        LOG.debug("Rule {} is enabled on the server, but not available in SonarLint", (Object)activeRuleFromStorage.getRuleKey());
                        continue;
                    }
                }
                if (!this.shouldIncludeRuleForAnalysis(ruleOrTemplateDefinition)) continue;
                analysisRulesContext.includeRule(ruleOrTemplateDefinition, activeRuleFromStorage);
            }
        });
        if (!this.serverConnection.supportsSecretAnalysis()) {
            this.analysisContext.get().allRulesDefinitionsByKey.values().stream().filter(ruleDefinition -> ruleDefinition.getLanguage() == Language.SECRETS).filter(this::shouldIncludeRuleForAnalysis).forEach(analysisRulesContext::includeRule);
        }
        return analysisRulesContext;
    }

    private boolean shouldIncludeRuleForAnalysis(SonarLintRuleDefinition ruleDefinition) {
        return !ruleDefinition.getType().equals((Object)RuleType.SECURITY_HOTSPOT) || this.globalConfig.isHotspotsEnabled() && this.serverConnection.permitsHotspotTracking();
    }

    private ServerActiveRule tryConvertDeprecatedKeys(ServerActiveRule possiblyDeprecatedActiveRuleFromStorage) {
        if (StringUtils.isNotBlank(possiblyDeprecatedActiveRuleFromStorage.getTemplateKey())) {
            SonarLintRuleDefinition ruleOrTemplateDefinition = this.analysisContext.get().findRule(possiblyDeprecatedActiveRuleFromStorage.getTemplateKey()).orElse(null);
            if (ruleOrTemplateDefinition == null) {
                return possiblyDeprecatedActiveRuleFromStorage;
            }
            RuleKey ruleKeyPossiblyWithDeprecatedRepo = RuleKey.parse(possiblyDeprecatedActiveRuleFromStorage.getRuleKey());
            RuleKey templateRuleKeyWithCorrectRepo = RuleKey.parse(ruleOrTemplateDefinition.getKey());
            String ruleKey = new RuleKey(templateRuleKeyWithCorrectRepo.repository(), ruleKeyPossiblyWithDeprecatedRepo.rule()).toString();
            return new ServerActiveRule(ruleKey, possiblyDeprecatedActiveRuleFromStorage.getSeverity(), possiblyDeprecatedActiveRuleFromStorage.getParams(), ruleOrTemplateDefinition.getKey());
        }
        SonarLintRuleDefinition ruleOrTemplateDefinition = this.analysisContext.get().findRule(possiblyDeprecatedActiveRuleFromStorage.getRuleKey()).orElse(null);
        if (ruleOrTemplateDefinition == null) {
            return possiblyDeprecatedActiveRuleFromStorage;
        }
        return new ServerActiveRule(ruleOrTemplateDefinition.getKey(), possiblyDeprecatedActiveRuleFromStorage.getSeverity(), possiblyDeprecatedActiveRuleFromStorage.getParams(), null);
    }

    @Override
    public void sync(EndpointParams endpoint, HttpClient client, Set<String> projectKeys, @Nullable ClientProgressMonitor monitor) {
        SynchronizationResult result = this.serverConnection.sync(endpoint, client, projectKeys, new ProgressMonitor(monitor));
        if (result.hasAnalyzerBeenUpdated()) {
            this.restartAnalysisEngine();
        }
    }

    private void restartAnalysisEngine() {
        AnalysisContext oldAnalysisContext = this.start();
        oldAnalysisContext.finishGracefully();
    }

    @Override
    public CompletableFuture<ConnectedRuleDetails> getActiveRuleDetails(EndpointParams endpoint, HttpClient client, String ruleKey, @Nullable String projectKey) {
        AnalyzerConfiguration analyzerConfiguration;
        Optional<ServerActiveRule> storageActiveRule;
        Optional<SonarLintRuleDefinition> ruleDefFromPluginOpt = this.analysisContext.get().findRule(ruleKey);
        if (ruleDefFromPluginOpt.isPresent()) {
            SonarLintRuleDefinition ruleDefFromPlugin = ruleDefFromPluginOpt.get();
            if (!this.serverConnection.supportsSecretAnalysis() && ruleDefFromPlugin.getLanguage().equals((Object)Language.SECRETS) || projectKey == null) {
                return CompletableFuture.completedFuture(new ConnectedRuleDetails(ruleKey, ruleDefFromPlugin.getName(), ruleDefFromPlugin.getHtmlDescription(), ruleDefFromPlugin.getDefaultSeverity(), ruleDefFromPlugin.getType(), ruleDefFromPlugin.getLanguage(), ""));
            }
        }
        if (projectKey != null && (storageActiveRule = (analyzerConfiguration = this.serverConnection.getAnalyzerConfiguration(projectKey)).getRuleSetByLanguageKey().values().stream().flatMap(s -> s.getRules().stream()).filter(r -> this.tryConvertDeprecatedKeys((ServerActiveRule)r).getRuleKey().equals(ruleKey)).findFirst()).isPresent()) {
            ServerActiveRule activeRuleFromStorage = storageActiveRule.get();
            IssueSeverity serverSeverity = activeRuleFromStorage.getSeverity();
            if (StringUtils.isNotBlank(activeRuleFromStorage.getTemplateKey())) {
                SonarLintRuleDefinition templateRuleDefFromPlugin = this.analysisContext.get().findRule(activeRuleFromStorage.getTemplateKey()).orElseThrow(() -> new IllegalStateException("Unable to find rule definition for rule template " + activeRuleFromStorage.getTemplateKey()));
                return new ServerApi(new ServerApiHelper(endpoint, client)).rules().getRule(activeRuleFromStorage.getRuleKey()).thenApply(serverRule -> new ConnectedRuleDetails(ruleKey, serverRule.getName(), serverRule.getHtmlDesc(), serverSeverity, templateRuleDefFromPlugin.getType(), templateRuleDefFromPlugin.getLanguage(), serverRule.getHtmlNote()));
            }
            return new ServerApi(new ServerApiHelper(endpoint, client)).rules().getRule(activeRuleFromStorage.getRuleKey()).thenApply(serverRule -> ruleDefFromPluginOpt.map(ruleDefFromPlugin -> new ConnectedRuleDetails(ruleKey, ruleDefFromPlugin.getName(), ruleDefFromPlugin.getHtmlDescription(), Optional.ofNullable(serverSeverity).orElse(ruleDefFromPlugin.getDefaultSeverity()), ruleDefFromPlugin.getType(), ruleDefFromPlugin.getLanguage(), serverRule.getHtmlNote())).orElse(new ConnectedRuleDetails(ruleKey, serverRule.getName(), serverRule.getHtmlDesc(), Optional.ofNullable(serverSeverity).orElse(serverRule.getSeverity()), serverRule.getType(), serverRule.getLanguage(), serverRule.getHtmlNote())));
        }
        throw new IllegalStateException("Unable to find rule details for '" + ruleKey + "'");
    }

    @Override
    public Collection<PluginDetails> getPluginDetails() {
        return this.analysisContext.get().pluginDetails;
    }

    @Override
    public Map<String, ServerProject> downloadAllProjects(EndpointParams endpoint, HttpClient client, @Nullable ClientProgressMonitor monitor) {
        return this.wrapErrors(() -> this.serverConnection.downloadAllProjects(endpoint, client, new ProgressMonitor(monitor)));
    }

    @Override
    public ProjectBranches getServerBranches(String projectKey) {
        org.sonarsource.sonarlint.core.serverconnection.ProjectBranches projectBranchesFromStorage = this.serverConnection.getProjectBranches(projectKey);
        return ConnectedSonarLintEngineImpl.toApi(projectBranchesFromStorage);
    }

    private static ProjectBranches toApi(org.sonarsource.sonarlint.core.serverconnection.ProjectBranches projectBranchesFromStorage) {
        return new ProjectBranches(projectBranchesFromStorage.getBranchNames(), projectBranchesFromStorage.getMainBranchName());
    }

    @Override
    public List<ServerIssue> getServerIssues(ProjectBinding projectBinding, String branchName, String ideFilePath) {
        return this.serverConnection.getServerIssues(projectBinding, branchName, ideFilePath);
    }

    @Override
    public List<ServerTaintIssue> getServerTaintIssues(ProjectBinding projectBinding, String branchName, String ideFilePath, boolean includeResolved) {
        return this.serverConnection.getServerTaintIssues(projectBinding, branchName, ideFilePath, includeResolved);
    }

    @Override
    public List<ServerTaintIssue> getAllServerTaintIssues(ProjectBinding projectBinding, String branchName) {
        return this.serverConnection.getServerTaintIssues(projectBinding, branchName);
    }

    @Override
    public <G> List<G> getExcludedFiles(ProjectBinding projectBinding, Collection<G> files, Function<G, String> fileIdePathExtractor, Predicate<G> testFilePredicate) {
        AnalyzerConfiguration analyzerConfig;
        try {
            analyzerConfig = this.serverConnection.getAnalyzerConfiguration(projectBinding.projectKey());
        }
        catch (StorageException e) {
            LOG.debug("Unable to read settings in local storage", (Object)e);
            return List.of();
        }
        MapSettings settings = new MapSettings(analyzerConfig.getSettings().getAll());
        ServerFileExclusions exclusionFilters = new ServerFileExclusions(settings.asConfig());
        exclusionFilters.prepare();
        ArrayList<G> excluded = new ArrayList<G>();
        for (G file : files) {
            InputFile.Type type;
            String idePath = fileIdePathExtractor.apply(file);
            if (idePath == null) continue;
            String sqPath = IssueStorePaths.idePathToServerPath(projectBinding, idePath);
            if (sqPath == null) {
                sqPath = idePath;
            }
            if (exclusionFilters.accept(sqPath, type = testFilePredicate.test(file) ? InputFile.Type.TEST : InputFile.Type.MAIN)) continue;
            excluded.add(file);
        }
        return excluded;
    }

    @Override
    public void subscribeForEvents(EndpointParams endpoint, HttpClient client, Set<String> projectKeys, Consumer<ServerEvent> eventConsumer, @Nullable ClientLogOutput clientLogOutput) {
        this.serverConnection.subscribeForEvents(endpoint, client, projectKeys, eventConsumer);
    }

    @Override
    public void downloadAllServerIssuesForFile(EndpointParams endpoint, HttpClient client, ProjectBinding projectBinding, String ideFilePath, String branchName, @Nullable ClientProgressMonitor monitor) {
        this.serverConnection.downloadServerIssuesForFile(endpoint, client, projectBinding, ideFilePath, branchName);
    }

    @Override
    public void downloadAllServerTaintIssuesForFile(EndpointParams endpoint, HttpClient client, ProjectBinding projectBinding, String ideFilePath, String branchName, @Nullable ClientProgressMonitor monitor) {
        this.serverConnection.downloadServerTaintIssuesForFile(endpoint, client, projectBinding, ideFilePath, branchName, new ProgressMonitor(monitor));
    }

    @Override
    public void downloadAllServerIssues(EndpointParams endpoint, HttpClient client, String projectKey, String branchName, @Nullable ClientProgressMonitor monitor) {
        this.serverConnection.downloadServerIssuesForProject(endpoint, client, projectKey, branchName);
    }

    @Override
    public void syncServerIssues(EndpointParams endpoint, HttpClient client, String projectKey, String branchName, @Nullable ClientProgressMonitor monitor) {
        this.serverConnection.syncServerIssuesForProject(endpoint, client, projectKey, branchName);
    }

    @Override
    public void syncServerTaintIssues(EndpointParams endpoint, HttpClient client, String projectKey, String branchName, @Nullable ClientProgressMonitor monitor) {
        this.serverConnection.syncServerTaintIssuesForProject(endpoint, client, projectKey, branchName);
    }

    @Override
    public void syncServerHotspots(EndpointParams endpoint, HttpClient client, String projectKey, String branchName, @Nullable ClientProgressMonitor monitor) {
        this.serverConnection.syncServerHotspotsForProject(endpoint, client, projectKey, branchName);
    }

    @Override
    public void downloadAllServerHotspots(EndpointParams endpoint, HttpClient client, String projectKey, String branchName, @Nullable ClientProgressMonitor monitor) {
        this.serverConnection.downloadAllServerHotspots(endpoint, client, projectKey, branchName, new ProgressMonitor(monitor));
    }

    @Override
    public void downloadAllServerHotspotsForFile(EndpointParams endpoint, HttpClient client, ProjectBinding projectBinding, String ideFilePath, String branchName, @Nullable ClientProgressMonitor monitor) {
        this.serverConnection.downloadAllServerHotspotsForFile(endpoint, client, projectBinding, ideFilePath, branchName);
    }

    @Override
    public Collection<ServerHotspot> getServerHotspots(ProjectBinding projectBinding, String branchName, String ideFilePath) {
        return this.serverConnection.getServerHotspots(projectBinding, branchName, ideFilePath);
    }

    @Override
    public ProjectBinding calculatePathPrefixes(String projectKey, Collection<String> ideFilePaths) {
        return this.serverConnection.calculatePathPrefixes(projectKey, ideFilePaths);
    }

    @Override
    public void updateProject(EndpointParams endpoint, HttpClient client, String projectKey, @Nullable ClientProgressMonitor monitor) {
        Objects.requireNonNull(endpoint);
        Objects.requireNonNull(projectKey);
        this.setLogging(null);
        this.serverConnection.updateProject(endpoint, client, projectKey, new ProgressMonitor(monitor));
    }

    @Override
    public void stop(boolean deleteStorage) {
        this.setLogging(null);
        try {
            this.analysisContext.get().destroy();
            this.serverConnection.stop(deleteStorage);
        }
        catch (Exception e) {
            throw SonarLintWrappedException.wrap(e);
        }
    }

    private <T> T wrapErrors(Supplier<T> callable) {
        this.setLogging(null);
        try {
            return callable.get();
        }
        catch (RuntimeException e) {
            throw SonarLintWrappedException.wrap(e);
        }
    }

    private static class AnalysisContext {
        private final Collection<PluginDetails> pluginDetails;
        private final Map<String, SonarLintRuleDefinition> allRulesDefinitionsByKey;
        private final Map<String, String> deprecatedRuleKeysMapping;
        private final AnalysisEngine analysisEngine;

        public AnalysisContext(List<PluginDetails> pluginDetails, Map<String, SonarLintRuleDefinition> allRulesDefinitionsByKey, AnalysisEngine analysisEngine) {
            this.pluginDetails = pluginDetails;
            this.allRulesDefinitionsByKey = allRulesDefinitionsByKey;
            this.analysisEngine = analysisEngine;
            this.deprecatedRuleKeysMapping = allRulesDefinitionsByKey.values().stream().flatMap(r -> r.getDeprecatedKeys().stream().map(dk -> Map.entry(dk, r.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public void destroy() {
            this.analysisEngine.stop();
        }

        public void finishGracefully() {
            this.analysisEngine.finishGracefully();
        }

        public Optional<SonarLintRuleDefinition> findRule(String ruleKey) {
            if (this.deprecatedRuleKeysMapping.containsKey(ruleKey)) {
                return Optional.of(this.allRulesDefinitionsByKey.get(this.deprecatedRuleKeysMapping.get(ruleKey)));
            }
            return Optional.ofNullable(this.allRulesDefinitionsByKey.get(ruleKey));
        }
    }

    private static class ActiveRulesContext {
        private final boolean shouldSkipCleanCodeTaxonomy;
        private final List<ActiveRule> activeRules = new ArrayList<ActiveRule>();
        private final Map<String, ActiveRuleMetadata> activeRulesMetadata = new HashMap<String, ActiveRuleMetadata>();

        private ActiveRulesContext(boolean shouldSkipCleanCodeTaxonomy) {
            this.shouldSkipCleanCodeTaxonomy = shouldSkipCleanCodeTaxonomy;
        }

        public void includeRule(SonarLintRuleDefinition ruleOrTemplateDefinition, ServerActiveRule activeRule) {
            ActiveRule activeRuleForAnalysis = new ActiveRule(activeRule.getRuleKey(), ruleOrTemplateDefinition.getLanguage().getLanguageKey());
            activeRuleForAnalysis.setTemplateRuleKey(StringUtils.trimToNull(activeRule.getTemplateKey()));
            activeRuleForAnalysis.setParams(ActiveRulesContext.getEffectiveParams(ruleOrTemplateDefinition, activeRule));
            this.activeRules.add(activeRuleForAnalysis);
            this.activeRulesMetadata.put(activeRule.getRuleKey(), new ActiveRuleMetadata(activeRule.getSeverity(), ruleOrTemplateDefinition.getType(), ruleOrTemplateDefinition.getCleanCodeAttribute().orElse(CleanCodeAttribute.defaultCleanCodeAttribute()), ruleOrTemplateDefinition.getDefaultImpacts()));
        }

        private static Map<String, String> getEffectiveParams(SonarLintRuleDefinition ruleOrTemplateDefinition, ServerActiveRule activeRule) {
            HashMap<String, String> effectiveParams = new HashMap<String, String>(ruleOrTemplateDefinition.getDefaultParams());
            activeRule.getParams().forEach((paramName, paramValue) -> {
                if (!ruleOrTemplateDefinition.getParams().containsKey(paramName)) {
                    AbstractSonarLintEngine.LOG.debug("Rule parameter '{}' for rule '{}' does not exist in embedded analyzer, ignoring.", paramName, (Object)ruleOrTemplateDefinition.getKey());
                    return;
                }
                effectiveParams.put((String)paramName, (String)paramValue);
            });
            return effectiveParams;
        }

        public void includeRule(SonarLintRuleDefinition rule) {
            ActiveRule activeRuleForAnalysis = new ActiveRule(rule.getKey(), rule.getLanguage().getLanguageKey());
            activeRuleForAnalysis.setParams(rule.getDefaultParams());
            this.activeRules.add(activeRuleForAnalysis);
            this.activeRulesMetadata.put(activeRuleForAnalysis.getRuleKey(), new ActiveRuleMetadata(rule.getDefaultSeverity(), rule.getType(), rule.getCleanCodeAttribute().orElse(CleanCodeAttribute.defaultCleanCodeAttribute()), rule.getDefaultImpacts()));
        }

        private ActiveRuleMetadata getRuleMetadata(String ruleKey) {
            return this.activeRulesMetadata.get(ruleKey);
        }

        private static class ActiveRuleMetadata {
            private final IssueSeverity severity;
            private final RuleType type;
            private final CleanCodeAttribute cleanCodeAttribute;
            private final Map<SoftwareQuality, ImpactSeverity> defaultImpacts;

            private ActiveRuleMetadata(IssueSeverity severity, RuleType type, CleanCodeAttribute cleanCodeAttribute, Map<SoftwareQuality, ImpactSeverity> defaultImpacts) {
                this.severity = severity;
                this.type = type;
                this.cleanCodeAttribute = cleanCodeAttribute;
                this.defaultImpacts = defaultImpacts;
            }
        }
    }
}

