/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.scanner;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class LineRange {
    private final int from;
    private final int to;

    public LineRange(int line) {
        this(line, line);
    }

    public LineRange(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException(String.format("Line range is not valid: %s must be greater or equal than %s", to, from));
        }
        this.from = from;
        this.to = to;
    }

    public boolean in(int lineId) {
        return this.from <= lineId && lineId <= this.to;
    }

    public Set<Integer> toLines() {
        LinkedHashSet<Integer> lines = new LinkedHashSet<Integer>(this.to - this.from + 1);
        for (int index = this.from; index <= this.to; ++index) {
            lines.add(index);
        }
        return lines;
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    public String toString() {
        return "[" + this.from + "-" + this.to + "]";
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return !this.fieldsDiffer((LineRange)obj);
    }

    private boolean fieldsDiffer(LineRange other) {
        return this.from != other.from || this.to != other.to;
    }
}

