/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.sonarapi;

import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonarsource.sonarlint.core.analysis.api.Issue;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.DefaultTextPointer;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.DefaultTextRange;
import org.sonarsource.sonarlint.core.commons.TextRange;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.builder.ToStringStyle;

public class DefaultFilterableIssue
implements FilterableIssue {
    private final Issue rawIssue;
    private final InputComponent component;

    public DefaultFilterableIssue(Issue rawIssue, InputComponent component) {
        this.rawIssue = rawIssue;
        this.component = component;
    }

    @Override
    public String componentKey() {
        return this.component.key();
    }

    @Override
    public RuleKey ruleKey() {
        return RuleKey.parse(this.rawIssue.getRuleKey());
    }

    @Override
    public String severity() {
        throw DefaultFilterableIssue.unsupported();
    }

    @Override
    public String message() {
        throw DefaultFilterableIssue.unsupported();
    }

    @Override
    public Integer line() {
        return this.rawIssue.getStartLine();
    }

    @Override
    public String projectKey() {
        throw DefaultFilterableIssue.unsupported();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Not available for issues filters");
    }

    @Override
    public Double gap() {
        throw DefaultFilterableIssue.unsupported();
    }

    public InputComponent getComponent() {
        return this.component;
    }

    @Override
    public org.sonar.api.batch.fs.TextRange textRange() {
        TextRange textRange = this.rawIssue.getTextRange();
        if (textRange == null) {
            return null;
        }
        return new DefaultTextRange(new DefaultTextPointer(textRange.getStartLine(), textRange.getStartLineOffset()), new DefaultTextPointer(textRange.getEndLine(), textRange.getEndLineOffset()));
    }
}

