/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;

public class DateUtils {
    private DateUtils() {
    }

    public static String toAge(long time) {
        LocalDateTime now;
        LocalDateTime creation = LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
        long years = ChronoUnit.YEARS.between(creation, now = LocalDateTime.now());
        if (years > 0L) {
            return DateUtils.pluralize(years, "year");
        }
        long months = ChronoUnit.MONTHS.between(creation, now);
        if (months > 0L) {
            return DateUtils.pluralize(months, "month");
        }
        long days = ChronoUnit.DAYS.between(creation, now);
        if (days > 0L) {
            return DateUtils.pluralize(days, "day");
        }
        long hours = ChronoUnit.HOURS.between(creation, now);
        if (hours > 0L) {
            return DateUtils.pluralize(hours, "hour");
        }
        long minutes = ChronoUnit.MINUTES.between(creation, now);
        if (minutes > 0L) {
            return DateUtils.pluralize(minutes, "minute");
        }
        return "few seconds ago";
    }

    private static String pluralize(long strictlyPositiveCount, String singular) {
        return DateUtils.pluralize(strictlyPositiveCount, singular, singular + "s");
    }

    private static String pluralize(long strictlyPositiveCount, String singular, String plural) {
        if (strictlyPositiveCount == 1L) {
            return "1 " + singular + " ago";
        }
        return strictlyPositiveCount + " " + plural + " ago";
    }
}

