/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.Version;

public class PluginsMinVersions {
    public static final String MIN_VERSIONS_FILE = "/plugins_min_versions.txt";
    private final Properties minimalPluginVersions = new Properties();

    public PluginsMinVersions() {
        try {
            this.minimalPluginVersions.load(this.getClass().getResourceAsStream(MIN_VERSIONS_FILE));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load minimum plugin versions", e);
        }
    }

    @CheckForNull
    public String getMinimumVersion(String key) {
        return this.minimalPluginVersions.getProperty(key);
    }

    public boolean isVersionSupported(String key, @Nullable String version) {
        if (version != null) {
            Version v = Version.create(version);
            return this.isVersionSupported(key, v);
        }
        return true;
    }

    public boolean isVersionSupported(String key, @Nullable Version version) {
        String minVersion = this.getMinimumVersion(key);
        if (version != null && minVersion != null) {
            Version minimalVersion = Version.create(minVersion);
            return version.compareToIgnoreQualifier(minimalVersion) >= 0;
        }
        return true;
    }
}

