/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.push.parsing;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.push.RuleSetChangedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.EventParser;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class RuleSetChangedEventParser
implements EventParser<RuleSetChangedEvent> {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Gson gson = new Gson();

    @Override
    public Optional<RuleSetChangedEvent> parse(String jsonData) {
        RuleSetChangedEventPayload payload = this.gson.fromJson(jsonData, RuleSetChangedEventPayload.class);
        if (payload.isInvalid()) {
            LOG.error("Invalid payload for 'RuleSetChanged' event: {}", (Object)jsonData);
            return Optional.empty();
        }
        return Optional.of(new RuleSetChangedEvent(payload.projects, payload.activatedRules.stream().map(changedRule -> new RuleSetChangedEvent.ActiveRule(changedRule.key, changedRule.language, IssueSeverity.valueOf(changedRule.severity), changedRule.params.stream().collect(Collectors.toMap(p -> p.key, p -> p.value)), changedRule.templateKey)).collect(Collectors.toList()), payload.deactivatedRules));
    }

    private static class RuleSetChangedEventPayload {
        private List<String> projects;
        private List<ActiveRulePayload> activatedRules;
        private List<String> deactivatedRules;

        private RuleSetChangedEventPayload() {
        }

        private boolean isInvalid() {
            return ServerApiUtils.isBlank(this.projects) || ServerApiUtils.areBlank(this.activatedRules, this.deactivatedRules);
        }

        private static class RuleParameterPayload {
            private String key;
            private String value;

            private RuleParameterPayload() {
            }
        }

        private static class ActiveRulePayload {
            private String key;
            private String language;
            private String severity;
            private List<RuleParameterPayload> params;
            private String templateKey;

            private ActiveRulePayload() {
            }
        }
    }
}

