/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.function.Consumer;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.telemetry.InternalDebug;
import org.sonarsource.sonarlint.core.telemetry.LocalDateAdapter;
import org.sonarsource.sonarlint.core.telemetry.LocalDateTimeAdapter;
import org.sonarsource.sonarlint.core.telemetry.OffsetDateTimeAdapter;
import org.sonarsource.sonarlint.core.telemetry.TelemetryLocalStorage;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;
import org.sonarsource.sonarlint.shaded.com.google.gson.GsonBuilder;

public class TelemetryLocalStorageManager {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Path path;
    private final Gson gson;

    public TelemetryLocalStorageManager(Path path) {
        this.path = path;
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)OffsetDateTime.class), new OffsetDateTimeAdapter().nullSafe()).registerTypeAdapter((Type)((Object)LocalDate.class), new LocalDateAdapter().nullSafe()).registerTypeAdapter((Type)((Object)LocalDateTime.class), new LocalDateTimeAdapter().nullSafe()).create();
    }

    public void tryUpdateAtomically(Consumer<TelemetryLocalStorage> updater) {
        block2: {
            try {
                this.updateAtomically(updater);
            }
            catch (Exception e) {
                if (!InternalDebug.isEnabled()) break block2;
                LOG.error("Error updating telemetry data", e);
                throw new IllegalStateException(e);
            }
        }
    }

    private synchronized void updateAtomically(Consumer<TelemetryLocalStorage> updater) throws IOException {
        Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
        try (FileChannel fileChannel = FileChannel.open(this.path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.SYNC);
             FileLock lock = fileChannel.lock();){
            TelemetryLocalStorage newData = this.readAtomically(fileChannel);
            updater.accept(newData);
            this.writeAtomically(fileChannel, newData);
        }
    }

    private TelemetryLocalStorage readAtomically(FileChannel fileChannel) {
        try {
            if (fileChannel.size() == 0L) {
                return new TelemetryLocalStorage();
            }
            ByteBuffer buf = ByteBuffer.allocate((int)fileChannel.size());
            fileChannel.read(buf);
            byte[] decoded = Base64.getDecoder().decode(buf.array());
            String oldJson = new String(decoded, StandardCharsets.UTF_8);
            TelemetryLocalStorage previousData = this.gson.fromJson(oldJson, TelemetryLocalStorage.class);
            return TelemetryLocalStorage.validateAndMigrate(previousData);
        }
        catch (Exception e) {
            if (InternalDebug.isEnabled()) {
                LOG.error("Error reading telemetry data", e);
                throw new IllegalStateException(e);
            }
            return new TelemetryLocalStorage();
        }
    }

    private void writeAtomically(FileChannel fileChannel, TelemetryLocalStorage newData) throws IOException {
        fileChannel.truncate(0L);
        String newJson = this.gson.toJson(newData);
        byte[] encoded = Base64.getEncoder().encode(newJson.getBytes(StandardCharsets.UTF_8));
        fileChannel.write(ByteBuffer.wrap(encoded));
    }

    public TelemetryLocalStorage tryRead() {
        try {
            if (!Files.exists(this.path, new LinkOption[0])) {
                return new TelemetryLocalStorage();
            }
            return this.read();
        }
        catch (Exception e) {
            if (InternalDebug.isEnabled()) {
                LOG.error("Error loading telemetry data", e);
                throw new IllegalStateException(e);
            }
            return new TelemetryLocalStorage();
        }
    }

    private TelemetryLocalStorage read() throws IOException {
        byte[] bytes = Files.readAllBytes(this.path);
        byte[] decoded = Base64.getDecoder().decode(bytes);
        String json = new String(decoded, StandardCharsets.UTF_8);
        TelemetryLocalStorage rawData = this.gson.fromJson(json, TelemetryLocalStorage.class);
        return TelemetryLocalStorage.validateAndMigrate(rawData);
    }
}

