/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.writer;

import com.teamscale.service.framework.versioning.VersionedMediaTypeUtils;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.string.StringUtils;

@Provider
@Produces(value={"application/*", "text/json"})
@Consumes(value={"application/*", "text/json"})
public class JsonStringSerializer
implements MessageBodyWriter<String>,
MessageBodyReader<String> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return VersionedMediaTypeUtils.isApplicableForSubtype((MediaType)mediaType, (String)"json");
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return VersionedMediaTypeUtils.isApplicableForSubtype((MediaType)mediaType, (String)"json");
    }

    public long getSize(String t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(String t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        OutputStreamWriter writer = new OutputStreamWriter(entityStream, StandardCharsets.UTF_8);
        writer.write(JsonUtils.serializeToJSON((Object)t));
        writer.flush();
    }

    public String readFrom(Class<String> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String string = StringUtils.fromInputStream((InputStream)entityStream);
        try {
            return (String)JsonUtils.deserializeFromJson((String)string, type);
        }
        catch (ConQATException e) {
            throw new IOException("Failed to deserialize entity", e);
        }
    }
}

