/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.util.function.BooleanSupplier;
import jetbrains.exodus.core.dataStructures.FakeObjectCache;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.execution.SharedTimer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ObjectCacheDecorator<K, V>
extends ObjectCacheBase<K, V> {
    private static final ObjectCacheBase FAKE_CACHE = new FakeObjectCache();
    @NotNull
    private final BooleanSupplier shouldCache;
    @Nullable
    private ObjectCacheBase<K, V> decorated;

    public ObjectCacheDecorator() {
        this(8192);
    }

    public ObjectCacheDecorator(int size) {
        this(size, () -> true);
    }

    public ObjectCacheDecorator(int size, @NotNull BooleanSupplier shouldCache) {
        super(size);
        this.shouldCache = shouldCache;
    }

    @Override
    public void clear() {
        if (this.decorated != null) {
            this.decorated.close();
            this.decorated = null;
        }
    }

    @Override
    public void lock() {
        this.getCache(true).lock();
    }

    @Override
    public void unlock() {
        this.getCache(false).unlock();
    }

    @Override
    public V cacheObject(@NotNull K key, @NotNull V x) {
        return this.getCache(true).cacheObject(key, x);
    }

    @Override
    public V remove(@NotNull K key) {
        return this.getCache(false).remove(key);
    }

    @Override
    public V tryKey(@NotNull K key) {
        return this.getCache(false).tryKey(key);
    }

    @Override
    public V getObject(@NotNull K key) {
        return this.getCache(false).getObject(key);
    }

    @Override
    public int count() {
        return this.getCache(false).count();
    }

    @Override
    public void close() {
        this.getCache(false).close();
    }

    @Override
    public int getAttempts() {
        return this.getCache(false).getAttempts();
    }

    @Override
    public int getHits() {
        return this.getCache(false).getHits();
    }

    @Override
    public float hitRate() {
        return this.getCache(false).hitRate();
    }

    @Override
    public ObjectCacheBase.CriticalSection newCriticalSection() {
        return this.getCache(true).newCriticalSection();
    }

    @Override
    protected void incAttempts() {
        this.getCache(false).incAttempts();
    }

    @Override
    protected void incHits() {
        this.getCache(false).incHits();
    }

    @Override
    @Nullable
    protected SharedTimer.ExpirablePeriodicTask getCacheAdjuster() {
        return null;
    }

    protected abstract ObjectCacheBase<K, V> createdDecorated();

    @NotNull
    private ObjectCacheBase<K, V> getCache(boolean create) {
        if (this.decorated == null) {
            if (!create) {
                return FAKE_CACHE;
            }
            this.decorated = this.createdDecorated();
        }
        return this.shouldCache.getAsBoolean() ? this.decorated : FAKE_CACHE;
    }
}

