/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap;

import com.google.common.base.Preconditions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.resource.util.UniformPathUtils;

public class UniqueAbapElementName {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final char OBJECT_NAME_SEPARATOR = '@';
    private final String objectName;
    private final EAbapObjectType objectType;
    private final String objectTypeString;

    public static UniqueAbapElementName of(String path) {
        try {
            return new ParsedAbapElementPath(path, false).getElementName();
        }
        catch (ConQATException e) {
            LOGGER.error("Not a valid ABAP element path: " + path + ". Will create a PROG element.", (Throwable)e);
            return new UniqueAbapElementName(UniformPathUtils.getElementName((String)path), EAbapObjectType.PROG);
        }
    }

    public UniqueAbapElementName(String objectName, EAbapObjectType objectType, String objectTypeString) {
        Preconditions.checkNotNull((Object)objectName);
        Preconditions.checkNotNull((Object)((Object)objectType));
        Preconditions.checkArgument((objectType != EAbapObjectType.UNKNOWN || objectTypeString != null ? 1 : 0) != 0, (Object)"The object type string must be given in case the type of the ABAP object is not known to Teamscale.");
        this.objectName = objectName.toUpperCase();
        this.objectType = objectType;
        this.objectTypeString = objectTypeString;
    }

    public UniqueAbapElementName(String objectName, EAbapObjectType objectType) {
        this(objectName, objectType, null);
    }

    public int hashCode() {
        return this.objectType.hashCode() + 31 * this.objectName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UniqueAbapElementName)) {
            return false;
        }
        UniqueAbapElementName other = (UniqueAbapElementName)obj;
        return this.objectType == other.objectType && this.objectName.equals(other.objectName) && (this.objectType != EAbapObjectType.UNKNOWN || this.objectTypeString.equals(other.objectTypeString));
    }

    public String getObjectName() {
        return this.objectName;
    }

    public EAbapObjectType getObjectType() {
        return this.objectType;
    }

    public String getObjectTypeName() {
        if (this.getObjectType() == EAbapObjectType.UNKNOWN) {
            return this.objectTypeString.toUpperCase();
        }
        return this.objectType.name();
    }

    public String getUniqueName() {
        return this.objectName + "@" + String.valueOf((Object)this.objectType);
    }

    public String toString() {
        return this.getUniqueName();
    }
}

