/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap.adt;

import com.google.common.net.UrlEscapers;
import java.net.URI;
import java.net.URISyntaxException;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EClassIncludeType;
import org.conqat.engine.core.core.ConQATException;
import org.jetbrains.annotations.VisibleForTesting;

public class AdtResourceUrls {
    private static final String URL_SCHEME = "adt";
    public static final String ADT_URL_PATH_CLAS = "/sap/bc/adt/oo/classes/%s/source/main";
    public static final String ADT_URL_PATH_CLAS_CCDEF = "/sap/bc/adt/oo/classes/%s/includes/definitions";
    public static final String ADT_URL_PATH_CLAS_CCIMP = "/sap/bc/adt/oo/classes/%s/includes/implementations";
    public static final String ADT_URL_PATH_CLAS_CCAU = "/sap/bc/adt/oo/classes/%s/includes/testclasses";
    public static final String ADT_URL_PATH_CLAS_CCMAC = "/sap/bc/adt/oo/classes/%s/includes/macros";
    public static final String ADT_URL_PATH_CLAS_CL = "/sap/bc/adt/oo/classes/%s/includes/localtypes";
    private static final String ADT_URL_PATH_INTF = "/sap/bc/adt/oo/interfaces/%s/source/main";
    private static final String ADT_URL_PATH_PROG = "/sap/bc/adt/programs/programs/%s/source/main";
    private static final String ADT_URL_PATH_PROG_INCLUDE = "/sap/bc/adt/programs/includes/%s/source/main";
    private static final String ADT_URL_PATH_FUGR = "/sap/bc/adt/functions/groups/%s/source/main";
    private static final String ADT_URL_PATH_FUGR_FMODULE = "/sap/bc/adt/functions/groups/%s/fmodules/%s/source/main";
    private static final String ADT_URL_PATH_FUGR_INCLUDE = "/sap/bc/adt/functions/groups/%s/includes/%s/source/main";
    private static final String ADT_URL_PATH_ENHO = "/sap/bc/adt/enhancements/enhoxh/%s/source/main";
    private static final String ADT_URL_PATH_DOMA = "/sap/bc/adt/vit/wb/object_type/domadd/object_name/%s";
    private static final String ADT_URL_PATH_DTEL = "/sap/bc/adt/ddic/dataelements/%s";
    private static final String ADT_URL_PATH_STRU = "/sap/bc/adt/ddic/structures/%s";
    private static final String ADT_URL_PATH_TABL = "/sap/bc/adt/vit/wb/object_type/tabldt/object_name/%s";
    private static final String ADT_URL_PATH_TTYP = "/sap/bc/adt/vit/wb/object_type/ttypda/object_name/%s";
    private static final String ADT_URL_PATH_TYPE = "/sap/bc/adt/ddic/typegroups/%s";
    private static final String ADT_URL_PATH_VIEW = "/sap/bc/adt/vit/wb/object_type/viewdv/object_name/%s";
    private static final String ADT_URL_PATH_BDEF = "/sap/bc/adt/bo/behaviordefinitions/%s";
    private static final String ADT_URL_PATH_DCLS = "/sap/bc/adt/acm/dcl/sources/%s";
    private static final String ADT_URL_PATH_DDLS = "/sap/bc/adt/ddic/ddl/sources/%s";
    private static final String ADT_URL_PATH_SRVD = "/sap/bc/adt/ddic/srvd/sources/%s";
    private static final String LOCATION_FRAGMENT = "start=%s,%s";

    public static URI createClassUrl(String sapSystemId, String classOrClassIncludeName, int line, int column) throws ConQATException {
        if (classOrClassIncludeName.length() <= 30) {
            return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_CLAS, classOrClassIncludeName, line, column);
        }
        for (EClassIncludeType includeType : EClassIncludeType.values()) {
            if (!includeType.matches(classOrClassIncludeName)) continue;
            String className = AbapUtils.extractClassName(classOrClassIncludeName);
            return AdtResourceUrls.createUrl(sapSystemId, includeType.getAdtUrlPathFormat(), className, line, column);
        }
        throw new ConQATException("Not a valid class name to create an ADT URL: " + classOrClassIncludeName);
    }

    public static URI createInterfaceUrl(String sapSystemId, String interfaceName, int line, int column) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_INTF, interfaceName, line, column);
    }

    public static URI createProgramUrl(String sapSystemId, String programName, int line, int column) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_PROG, programName, line, column);
    }

    public static URI createProgramIncludeUrl(String sapSystemId, String includeName, int line, int column) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_PROG_INCLUDE, includeName, line, column);
    }

    public static URI createFunctionGroupUrl(String sapSystemId, String functionGroupName, int line, int column) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_FUGR, functionGroupName, line, column);
    }

    public static URI createFunctionModuleUrl(String sapSystemId, String functionGroupName, String functionModuleName, int line, int column) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_FUGR_FMODULE, functionGroupName, functionModuleName, line, column);
    }

    public static URI createFunctionGroupIncludeUrl(String sapSystemId, String functionGroupName, String includeName, int line, int column) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_FUGR_INCLUDE, functionGroupName, includeName, line, column);
    }

    public static URI createEnhancementUrl(String sapSystemId, String enhancementName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_ENHO, enhancementName);
    }

    public static URI createDdicDomainUrl(String sapSystemId, String ddicDomainName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_DOMA, ddicDomainName);
    }

    public static URI createDdicDataElementUrl(String sapSystemId, String ddicDataElementName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_DTEL, ddicDataElementName);
    }

    public static URI createDdicStructureUrl(String sapSystemId, String ddicStructureName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_STRU, ddicStructureName);
    }

    public static URI createDdicTableUrl(String sapSystemId, String ddicTableName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_TABL, ddicTableName);
    }

    public static URI createDdicTableTypeUrl(String sapSystemId, String ddicTableName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_TTYP, ddicTableName);
    }

    public static URI createDdicTypeGroupUrl(String sapSystemId, String ddicTypeGroupName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_TYPE, ddicTypeGroupName);
    }

    public static URI createDdicViewUrl(String sapSystemId, String ddicViewName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_VIEW, ddicViewName);
    }

    public static URI createCdsBehaviorDefinitionUrl(String sapSystemId, String cdsBehaviorDefinitionName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_BDEF, cdsBehaviorDefinitionName);
    }

    public static URI createCdsRoleDefinitionEntityUrl(String sapSystemId, String roleDefinitionEntityName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_DCLS, roleDefinitionEntityName);
    }

    public static URI createCdsViewUrl(String sapSystemId, String viewName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_DDLS, viewName);
    }

    public static URI createCdsServiceDefinitionUrl(String sapSystemId, String serviceDefinitionName) throws ConQATException {
        return AdtResourceUrls.createUrl(sapSystemId, ADT_URL_PATH_SRVD, serviceDefinitionName);
    }

    private static URI createUrl(String sapSystemId, String pathFormat, String pathArg, int line, int column) throws ConQATException {
        return AdtResourceUrls.createRawUrl(sapSystemId, String.format(pathFormat, AdtResourceUrls.normalizeAbapName(pathArg)), line, column);
    }

    private static URI createUrl(String sapSystemId, String pathFormat, String pathArg) throws ConQATException {
        return AdtResourceUrls.createRawUrl(sapSystemId, String.format(pathFormat, AdtResourceUrls.normalizeAbapName(pathArg)), -1, -1);
    }

    private static URI createUrl(String sapSystemId, String pathFormat, String pathArg1, String pathArg2, int line, int column) throws ConQATException {
        return AdtResourceUrls.createRawUrl(sapSystemId, String.format(pathFormat, AdtResourceUrls.normalizeAbapName(pathArg1), AdtResourceUrls.normalizeAbapName(pathArg2)), line, column);
    }

    public static URI forLocation(URI url, int line, int column) throws ConQATException {
        return AdtResourceUrls.createRawUrl(url.getHost(), url.getPath(), line, column);
    }

    private static URI createRawUrl(String sapSystemId, String path, int line, int column) throws ConQATException {
        try {
            StringBuilder url = new StringBuilder();
            url.append(URL_SCHEME).append("://").append(sapSystemId).append(path);
            if (line >= 0 && column >= 0) {
                url.append('#').append(String.format(LOCATION_FRAGMENT, line, column));
            }
            return new URI(url.toString());
        }
        catch (URISyntaxException e) {
            throw new ConQATException("Malformed URL for ADT link", (Throwable)e);
        }
    }

    @VisibleForTesting
    static String normalizeAbapName(String name) {
        return UrlEscapers.urlPathSegmentEscaper().escape(name).toLowerCase();
    }
}

