/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.assessment.shared;

import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.commons.EAssessmentType;
import com.teamscale.index.architecture.commons.EPolicyType;
import com.teamscale.index.architecture.commons.EStereotype;
import com.teamscale.index.architecture.scope.ComponentNode;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class Dependency {
    private final ComponentNode source;
    private final ComponentNode target;
    private final EPolicyType policyType;
    private EAssessmentType assessmentType;
    private final Set<TypeDependency> dependencies = new HashSet<TypeDependency>();
    private final Set<TypeDependency> toleratedDependencies = new HashSet<TypeDependency>();

    public Dependency(ComponentNode source, ComponentNode target) {
        this.source = source;
        this.target = target;
        this.policyType = this.calculatePolicyType();
    }

    protected Dependency(ComponentNode source, ComponentNode target, EPolicyType policyType) {
        this.source = source;
        this.target = target;
        this.policyType = policyType;
    }

    public Dependency(ComponentNode source, ComponentNode target, EPolicyType policyType, EAssessmentType assessmentType, Set<TypeDependency> dependencies, Set<TypeDependency> toleratedDependencies) {
        this.source = source;
        this.target = target;
        this.policyType = policyType;
        this.assessmentType = assessmentType;
        this.dependencies.addAll(dependencies);
        this.toleratedDependencies.addAll(toleratedDependencies);
    }

    public final void addToleratedTypeDependency(TypeDependency dependency) {
        CCSMAssert.isTrue((this.policyType == EPolicyType.TOLERATE_EXPLICIT ? 1 : 0) != 0, (String)("Type dependencies can be tolerated only if the dependency's type is " + EPolicyType.TOLERATE_EXPLICIT.toString() + "."));
        this.toleratedDependencies.add(dependency);
    }

    public final void addTypeDependency(TypeDependency dependency) {
        this.dependencies.add(dependency);
    }

    public ComponentNode getSource() {
        return this.source;
    }

    public ComponentNode getTarget() {
        return this.target;
    }

    public EPolicyType getType() {
        return this.policyType;
    }

    public EAssessmentType getAssessment() {
        if (this.assessmentType == null) {
            this.assessmentType = this.assess();
        }
        return this.assessmentType;
    }

    private EAssessmentType assess() {
        boolean empty = !this.hasTypeLevelDependency();
        switch (this.policyType) {
            case ALLOW_EXPLICIT: 
            case ALLOW_IMPLICIT: {
                if (empty) {
                    return EAssessmentType.UNNECESSARY;
                }
                return EAssessmentType.VALID;
            }
            case DENY_IMPLICIT: 
            case DENY_EXPLICIT: {
                if (empty) {
                    return EAssessmentType.VALID;
                }
                return EAssessmentType.INVALID;
            }
            case TOLERATE_EXPLICIT: {
                if (empty) {
                    return EAssessmentType.UNNECESSARY;
                }
                for (TypeDependency dependency : this.getTypeDependencies()) {
                    if (this.toleratedDependencies.contains(dependency)) continue;
                    return EAssessmentType.INVALID;
                }
                return EAssessmentType.VALID;
            }
        }
        CCSMAssert.fail((String)("Unknown value: " + String.valueOf((Object)this.policyType)));
        return null;
    }

    private boolean hasTypeLevelDependency() {
        return !this.getTypeDependencies().isEmpty();
    }

    private EPolicyType calculatePolicyType() {
        if (this.source.hasPolicyTo(this.target)) {
            return this.source.getPolicyTo(this.target).getType();
        }
        for (ComponentNode sourceAncestor : this.source.getAncestors()) {
            for (ComponentNode targetAncestor : this.target.getAncestors()) {
                Optional<EPolicyType> policyType = Dependency.calculatePolicyType(sourceAncestor, targetAncestor);
                if (!policyType.isPresent()) continue;
                return policyType.get();
            }
        }
        return EPolicyType.DENY_IMPLICIT;
    }

    private static Optional<EPolicyType> calculatePolicyType(ComponentNode sourceAncestor, ComponentNode targetAncestor) {
        if (sourceAncestor.hasPolicyTo(targetAncestor)) {
            if (sourceAncestor.getPolicyTo(targetAncestor).getType() == EPolicyType.DENY_EXPLICIT) {
                return Optional.of(EPolicyType.DENY_IMPLICIT);
            }
            return Optional.of(EPolicyType.ALLOW_IMPLICIT);
        }
        if (Dependency.isPublic(targetAncestor) || Dependency.isAllowedComponentPublicAccess(sourceAncestor, targetAncestor)) {
            return Optional.of(EPolicyType.ALLOW_IMPLICIT);
        }
        return Optional.empty();
    }

    private static boolean isAllowedComponentPublicAccess(ComponentNode sourceAncestor, ComponentNode targetAncestor) {
        return targetAncestor.getStereotype() == EStereotype.COMPONENT_PUBLIC && !targetAncestor.isToplevel() && sourceAncestor.getAncestors().contains(targetAncestor.getParent());
    }

    private static boolean isPublic(ComponentNode targetAncestor) {
        return targetAncestor.getStereotype() == EStereotype.PUBLIC;
    }

    public Set<TypeDependency> getTypeDependencies() {
        return this.dependencies;
    }

    public Set<TypeDependency> getToleratedDependencies() {
        return this.toleratedDependencies;
    }

    public String toString() {
        return this.getSource().getName() + " -> " + this.getTarget().getName();
    }
}

