/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.snapshot;

import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.backup.BackupInfo;
import com.teamscale.index.backup.BackupLocationInfo;
import com.teamscale.index.backup.IBackupTarget;
import com.teamscale.index.backup.snapshot.AutoStorageSnapshotOption;
import com.teamscale.index.backup.snapshot.StorageSnapshotBackupUtils;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

public class AutoStorageSnapshotTrigger
extends OptionScheduledTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws StorageException {
        AutoStorageSnapshotOption option = (AutoStorageSnapshotOption)this.getTriggeringOption(AutoStorageSnapshotOption.class);
        BackupLocationInfo backupLocationInfo = new BackupLocationInfo(this.instanceConfiguration, option.getStorageLocation(), ZonedDateTime.now());
        IBackupTarget backupTarget = StorageSnapshotBackupUtils.writeSnapshotBackup(backupLocationInfo.getOutputUri(), this.indexLayer);
        try {
            AutoStorageSnapshotTrigger.deleteOldSnapshots(backupLocationInfo, backupTarget, option.backupsToKeep);
        }
        catch (IOException e) {
            LOGGER.error("Failed to clean up old backups: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void deleteOldSnapshots(BackupLocationInfo backupLocationInfo, IBackupTarget backupTarget, int backupsToKeep) throws IOException {
        if (backupsToKeep <= 0) {
            return;
        }
        List<BackupInfo> backupsInSameLocation = backupTarget.getBackupsInSameLocation(backupLocationInfo);
        List<BackupInfo> backupsToDelete = backupsInSameLocation.stream().sorted(Comparator.reverseOrder()).skip(backupsToKeep).collect(Collectors.toList());
        if (!backupsToDelete.isEmpty()) {
            backupTarget.deleteBackupsInSameLocation(backupsToDelete);
        }
    }

    public ETriggerCost getExpectedCost() {
        return ETriggerCost.EXPENSIVE;
    }
}

