/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.write;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.backup.write.EExternalDataExportGranularity;
import com.teamscale.index.backup.write.EExternalDataExportTarget;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class ExternalUploadExportOption
implements Serializable {
    private static final String GRANULARITY_PROPERTY = "granularity";
    private static final String TARGET_PROPERTY = "target";
    private static final String BEFORE_TIMESTAMP_PROPERTY = "beforeTimestamp";
    private static final String BRANCH_PATTERN_PROPERTY = "branchPattern";
    private static final String PARTITION_PATTERN_PROPERTY = "partitionPattern";
    private static final String PROJECT_PATTERN_PROPERTY = "projectPattern";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="granularity")
    private final EExternalDataExportGranularity granularity;
    @JsonProperty(value="target")
    private final EExternalDataExportTarget target;
    @JsonProperty(value="beforeTimestamp")
    private final long beforeTimestamp;
    @JsonProperty(value="branchPattern")
    private final String branchPattern;
    @JsonProperty(value="partitionPattern")
    private final String partitionPattern;
    @JsonProperty(value="projectPattern")
    private final String projectPattern;
    @JsonIgnore
    private transient Pattern compiledBranchPattern;
    @JsonIgnore
    private transient Pattern compiledPartitionPattern;
    @JsonIgnore
    private transient Pattern compiledProjectPattern;

    @JsonCreator
    public ExternalUploadExportOption(@JsonProperty(value="granularity") EExternalDataExportGranularity granularity, @JsonProperty(value="target") EExternalDataExportTarget target, @JsonProperty(value="beforeTimestamp") long beforeTimestamp, @JsonProperty(value="branchPattern") String branchPattern, @JsonProperty(value="partitionPattern") String partitionPattern, @JsonProperty(value="projectPattern") String projectPattern) {
        this.granularity = granularity;
        this.target = target;
        this.beforeTimestamp = beforeTimestamp;
        this.branchPattern = branchPattern;
        this.partitionPattern = partitionPattern;
        this.projectPattern = projectPattern;
    }

    public boolean isApplicableFor(EExternalDataExportTarget target) {
        return target == this.target || this.target == EExternalDataExportTarget.ALL;
    }

    public boolean isApplicableFor(@Nullable PublicProjectId projectId, String branchName, @Nullable String partition, long timestamp) {
        return !(projectId != null && !this.getCompiledProjectPattern().matcher(projectId.toString()).matches() || timestamp >= this.beforeTimestamp || !this.getCompiledBranchPattern().matcher(branchName).matches() || partition != null && !this.getCompiledPartitionPattern().matcher(partition).matches());
    }

    private Pattern getCompiledBranchPattern() {
        if (this.compiledBranchPattern == null) {
            this.compiledBranchPattern = Pattern.compile(this.branchPattern);
        }
        return this.compiledBranchPattern;
    }

    private Pattern getCompiledPartitionPattern() {
        if (this.compiledPartitionPattern == null) {
            this.compiledPartitionPattern = Pattern.compile(this.partitionPattern);
        }
        return this.compiledPartitionPattern;
    }

    private Pattern getCompiledProjectPattern() {
        if (this.compiledProjectPattern == null) {
            this.compiledProjectPattern = Pattern.compile(this.projectPattern);
        }
        return this.compiledProjectPattern;
    }

    public EExternalDataExportGranularity getGranularity() {
        return this.granularity;
    }
}

