/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.metadata.MetaDataMetricSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;

public class FileMetadataConfiguration
extends AnalysisConfigurationBase {
    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        FileMetadataConfiguration.registerAbapMetrics(proxy.getCodeMetricSchema());
        proxy.createTrigger(new TriggerBuilder(MetaDataMetricSynchronizer.class, ETriggerConcurrency.PARALLEL));
    }

    private static void registerAbapMetrics(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addMetric("creationDate", schema.createMetricIndexSource("creationDate"), "Creation Date", "Creation date (as reported by the SAP system)", EMetricValueType.DATE_ONLY, MetricDirectorySchemaEntry.EAggregation.MIN, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
        schema.addMetric("lastUpdateDateTime", schema.createMetricIndexSource("lastUpdateDateTime"), "Latest Update", "Update date and time (as reported by the SAP system)", EMetricValueType.TIMESTAMP, MetricDirectorySchemaEntry.EAggregation.MAX, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
        schema.addMetric("originatingSystem", schema.createMetricIndexSource("originatingSystem"), "Originating System", "The originating SAP system", EMetricValueType.COUNTER_SET, MetricDirectorySchemaEntry.EAggregation.UNION, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
        schema.addMetric("programType", schema.createMetricIndexSource("programType"), "Program Type", "The program type, e.g. Function Pool, Class Include, Executable Program", EMetricValueType.COUNTER_SET, MetricDirectorySchemaEntry.EAggregation.UNION, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
        schema.addMetric("languageVersion", schema.createMetricIndexSource("languageVersion"), "Language Version", "The language version (Standard ABAP, ABAP for Key Users, or ABAP Cloud)", EMetricValueType.COUNTER_SET, MetricDirectorySchemaEntry.EAggregation.UNION, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
        schema.addMetric("authorizationGroup", schema.createMetricIndexSource("authorizationGroup"), "Authorization Group", "The authorization group. Only applicable for executable programs, i.e., ABAP reports.", EMetricValueType.COUNTER_SET, MetricDirectorySchemaEntry.EAggregation.UNION, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
    }

    public boolean isCoreConfiguration() {
        return true;
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }
}

