/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.utils.matcher;

import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ExitStatementEntityMatcher
implements IShallowEntityMatcher {
    private static final TokenPattern EXIT_STATEMENT_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.LPAREN});
    private final Set<String> methodSignature;

    public ExitStatementEntityMatcher(String ... methodSignatures) {
        this.methodSignature = CollectionUtils.asHashSet((Object[])methodSignatures);
    }

    @Override
    public boolean matches(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.STATEMENT && entity.getSubtype().equals("simple statement") && this.isSystemExitStatement((List<IToken>)entity.ownStartTokens());
    }

    private boolean isSystemExitStatement(List<IToken> tokens) {
        TokenPatternMatch match = EXIT_STATEMENT_PATTERN.findFirstMatch(tokens);
        return match != null && this.methodSignature.contains(match.groupString(0));
    }

    public String toString() {
        return "ExitStatementEntityMatcher";
    }
}

