/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.deadstore;

import com.teamscale.index.dataflow.DataFlowGraphIncludingLambdas;
import com.teamscale.index.dataflow.DataflowAnalysisBase;
import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.EDirection;
import com.teamscale.index.dataflow.IDataFlowGraph;
import com.teamscale.index.dataflow.IDataflowFindingsCreator;
import com.teamscale.index.dataflow.ILattice;
import com.teamscale.index.dataflow.PathInsensitiveDataflowAnalysisBase;
import com.teamscale.index.dataflow.TernaryLattice;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.CDataflowUtils;
import com.teamscale.index.dataflow.deadstore.DeadStoreAnalysisFindingsCreator;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public class DeadStoreAnalysis
extends PathInsensitiveDataflowAnalysisBase<String, ELiveness> {
    private static final TernaryLattice<ELiveness> LATTICE = new TernaryLattice<ELiveness>(ELiveness.UNKNOWN, ELiveness.DEAD, ELiveness.LIVE);
    private final Set<String> definedVariablesInCurrentCfgCache = new HashSet<String>();
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    protected Deque<DataflowAnalysisBase.WorkItem> initializeAnalysis(ControlFlowGraph cfg) throws ConQATException {
        this.definedVariablesInCurrentCfgCache.clear();
        this.initializeDefinedVariablesCache(cfg);
        Deque<DataflowAnalysisBase.WorkItem> analysisStack = super.initializeAnalysis(cfg);
        CCSMAssert.isTrue((boolean)cfg.getExitNode().isSynthetic(), (String)"The dead store analysis needs a synthetic exit node.");
        return analysisStack;
    }

    private void initializeDefinedVariablesCache(ControlFlowGraph cfg) {
        ArrayDeque<ControlFlowGraph> cfgsToBeProcessed = new ArrayDeque<ControlFlowGraph>();
        IdentityHashSet seen = new IdentityHashSet();
        cfgsToBeProcessed.add(cfg);
        while (!cfgsToBeProcessed.isEmpty()) {
            ControlFlowGraph current = (ControlFlowGraph)cfgsToBeProcessed.pollFirst();
            if (!seen.add((Object)current)) {
                LOGGER.error("CFG for method {} in {}:{} contains cycle in lambda-cfg nesting.", (Object)cfg.getMethodName(), (Object)this.element.getUniformPath(), (Object)current.getEntities().getFirst().getStartLine());
                continue;
            }
            this.definedVariablesInCurrentCfgCache.addAll(current.getDefinedVariables());
            current.listDepthFirst().stream().map(ControlFlowNode::getLambdas).distinct().forEach(cfgsToBeProcessed::addAll);
        }
    }

    @Override
    public EDirection getDirection() {
        return EDirection.BACKWARD;
    }

    @Override
    protected IDataFlowGraph createDataFlowGraph(ControlFlowGraph controlFlowGraph) {
        return new DataFlowGraphIncludingLambdas(controlFlowGraph);
    }

    @Override
    protected ILattice<ELiveness> getLattice() {
        return LATTICE;
    }

    @Override
    protected Map<String, ELiveness> getDefaultState(ControlFlowNode node) {
        HashMap<String, ELiveness> state = new HashMap<String, ELiveness>();
        for (String variable : this.definedVariablesInCurrentCfgCache) {
            state.put(variable, this.getLattice().getBottom());
        }
        return state;
    }

    @Override
    protected UnmodifiableMap<String, ELiveness> getStartingInput(ControlFlowGraph cfg) {
        HashMap<String, ELiveness> state = new HashMap<String, ELiveness>();
        for (String variable : this.definedVariablesInCurrentCfgCache) {
            if (this.isMutablePointerOrReference(variable, cfg)) {
                state.put(variable, ELiveness.LIVE);
                continue;
            }
            state.put(variable, this.getLattice().getBottom());
        }
        return CollectionUtils.asUnmodifiable(state);
    }

    private boolean isMutablePointerOrReference(String variable, ControlFlowGraph cfg) {
        if (!LanguageGroups.C_CPP_AND_MS_CLI.contains(this.element.getLanguage())) {
            return false;
        }
        return CDataflowUtils.isPointerOrReferenceWithMutableValue(variable, cfg);
    }

    @Override
    protected UnmodifiableMap<String, ELiveness> transform(ControlFlowNode block, UnmodifiableMap<String, ELiveness> inState) {
        HashMap<String, ELiveness> outState = new HashMap<String, ELiveness>((Map<String, ELiveness>)inState);
        if (block.isAssumeNode()) {
            return CollectionUtils.asUnmodifiable(outState);
        }
        for (Map.Entry entry : outState.entrySet()) {
            if (entry.getValue() != ELiveness.UNKNOWN) continue;
            outState.put((String)entry.getKey(), ELiveness.DEAD);
        }
        for (VariableWrite write : block.getReadWriteInfo().getAllWrites()) {
            outState.put(write.getChangedVariable(), ELiveness.DEAD);
        }
        HashSet readVariables = CollectionUtils.unionSet(block.getReadWriteInfo().getReads(), (Collection[])new Collection[]{block.getReadWriteInfo().getDereferenceInfo().getDereferencedVariables()});
        for (String readVariable : readVariables) {
            outState.put(readVariable, ELiveness.LIVE);
            if (this.element.getLanguage() != ELanguage.ABAP) continue;
            DeadStoreAnalysis.reviveAbapStructMembers(readVariable, outState);
        }
        return CollectionUtils.asUnmodifiable(outState);
    }

    private static void reviveAbapStructMembers(String structName, Map<String, ELiveness> outState) {
        for (Map.Entry<String, ELiveness> entry : outState.entrySet()) {
            if (!entry.getKey().startsWith(structName + "-")) continue;
            outState.put(entry.getKey(), ELiveness.LIVE);
        }
    }

    @Override
    public IDataflowFindingsCreator<DataflowAnalysisResult<String, ELiveness>> createFindingsCreator(List<IFalsePositiveFilter> filters) {
        return new DeadStoreAnalysisFindingsCreator(filters);
    }

    public static enum ELiveness {
        UNKNOWN,
        DEAD,
        LIVE;

    }
}

