/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.external.ExternalUploadSessionRetentionOption;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;

@PeriodicMaintenanceJob(cronExpression="0 0 * * *")
public class ExternalUploadSessionCleanupTrigger
extends MaintenanceTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.indexLayer.openGlobalIndex(ServerOptionIndex.class);
        if (ExternalUploadSessionRetentionOption.isDisabled(serverOptionIndex)) {
            return;
        }
        int maxAgeDays = ExternalUploadSessionRetentionOption.getMaxAgeDays(serverOptionIndex);
        for (ProjectInfo project : ((ProjectIndex)this.indexLayer.openGlobalIndex(ProjectIndex.class)).getAllProjectInfos()) {
            this.deleteStaleSessionsForProject(maxAgeDays, project);
        }
    }

    private void deleteStaleSessionsForProject(int maxAgeDays, ProjectInfo project) throws StorageException {
        ExternalAnalysisImportSessionIndex sessionIndex = (ExternalAnalysisImportSessionIndex)this.indexLayer.openNonHistorizedProjectIndex(ExternalAnalysisImportSessionIndex.class, project);
        Collection<String> sessionIds = sessionIndex.getAllSessionIds();
        int deletionCount = 0;
        for (String sessionId : sessionIds) {
            Instant oldestAllowedTime;
            Instant uploadTime;
            ExternalAnalysisSessionInfo info;
            Optional<ExternalAnalysisSessionInfo> optSessionInfo = sessionIndex.getSessionInfo(sessionId);
            if (optSessionInfo.isEmpty() || !(info = optSessionInfo.get()).isOpen() || !(uploadTime = Instant.ofEpochMilli(info.getUploadTimestamp())).isBefore(oldestAllowedTime = Instant.now().minus(Duration.ofDays(maxAgeDays)))) continue;
            sessionIndex.deleteSession(sessionId);
            ++deletionCount;
        }
        if (deletionCount > 0) {
            LOGGER.warn("Deleted {} open sessions older than {} days in project {}. If sessions regularly need to be cleaned up, this might hint at a misconfiguration of upload services.", (Object)deletionCount, (Object)maxAgeDays, (Object)project.getPrimaryPublicId().projectId);
        }
    }
}

