/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.cron.CronExpression;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.scheduling.PeriodicMaintenanceJobRegistry;
import com.teamscale.index.external.ExternalStorageBackendResolvedCommitAndRevision;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.IntegrateImportedAnalysisResultsTrigger;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.repository.sap.abapsystem.SapTestwiseCoverageCommunicator;
import com.teamscale.index.testimpact.ManualSapTestInfo;
import com.teamscale.index.testimpact.TemporarySapTestInfoIndex;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.testwise_coverage.TestwiseCoverageReport;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;

public class LoadAndIntegrateSapTestwiseCoverageTrigger
extends PrivilegedTriggerBase {
    private static final CronExpression MINUTELY_SCHEDULING_CRON_EXPRESSION = CronExpression.of((String)"* * * * *");
    private static final String TARGET_PARTITION_FOR_COVERAGE_UPLOAD = "sap-coverage";
    private static final String TARGET_BRANCH_FOR_COVERAGE_UPLOAD = "master";
    private static final CounterSet<String> RETRIES_COUNTER = new CounterSet();
    private static final int MAX_NUMBER_OF_FAILED_RETRIES = 10;
    private static final String MESSAGE_OF_COVERAGE_UPLOAD = "Upload of testwise SAP coverage";
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws ConQATException {
        TemporarySapTestInfoIndex sapTestIndex = (TemporarySapTestInfoIndex)this.indexLayer.openGlobalIndex(TemporarySapTestInfoIndex.class);
        for (ManualSapTestInfo testInfo : sapTestIndex.getTestsToBeFetched()) {
            this.fetchReportAndTriggerCoverageIntegration(testInfo, sapTestIndex);
        }
        this.unschedulePeriodicalRetry(sapTestIndex);
        sapTestIndex.removeOldAndIntegratedReports();
    }

    private void fetchReportAndTriggerCoverageIntegration(ManualSapTestInfo sapTestInfo, TemporarySapTestInfoIndex sapTestIndex) throws ConQATException {
        Pair<String, String> reportAndLogFromSapServer;
        if (((ProjectIndex)this.indexLayer.openGlobalIndex(ProjectIndex.class)).tryResolveProject((IProjectId)sapTestInfo.getProjectId()).isEmpty()) {
            sapTestIndex.removeTestInfo(sapTestInfo.makeKey());
            LOGGER.warn("Ignoring Manual Sap Test Info because the project with the id " + String.valueOf(sapTestInfo.getProjectId()) + " does not exist.");
            return;
        }
        SapTestwiseCoverageCommunicator sapTiaCommunicatior = new SapTestwiseCoverageCommunicator((IProjectId)sapTestInfo.getProjectId(), sapTestInfo.getExecutingUser(), this.indexLayer);
        try {
            reportAndLogFromSapServer = sapTiaCommunicatior.getCoverageReportWithLog(sapTestInfo.makeKey());
        }
        catch (ConQATException e) {
            LoadAndIntegrateSapTestwiseCoverageTrigger.removeFromQueueIfRetriesExceeded(sapTestInfo.makeKey(), sapTestIndex, e);
            return;
        }
        String returnedReportOrStatusMessage = (String)reportAndLogFromSapServer.getFirst();
        if (returnedReportOrStatusMessage.equals("Coverage report not yet generated.")) {
            this.schedulePeriodicalRetry();
        } else {
            String returnedLog = (String)reportAndLogFromSapServer.getSecond();
            String report = returnedReportOrStatusMessage;
            LogManager.getLogger().info(returnedLog);
            try {
                report = LoadAndIntegrateSapTestwiseCoverageTrigger.addPartialFlagToReport(returnedReportOrStatusMessage);
            }
            catch (JsonSerializationException e) {
                LogManager.getLogger().error("Invalid JSON in testwise coverage report.", (Throwable)e);
            }
            sapTestInfo.setReport(report);
            sapTestInfo.setLogMessagesAfterProcessing(returnedLog);
            sapTestIndex.setTestInfo(sapTestInfo);
            this.integrateCoverageReport(sapTestInfo, report);
        }
    }

    private static String addPartialFlagToReport(String report) throws ConQATException {
        TestwiseCoverageReport testwiseCoverage = (TestwiseCoverageReport)JsonUtils.deserializeFromJson((String)report, TestwiseCoverageReport.class);
        testwiseCoverage.setPartial(true);
        return JsonUtils.serializeToJSON((Object)testwiseCoverage);
    }

    private void integrateCoverageReport(ManualSapTestInfo sapTestInfo, String report) throws StorageException {
        ExternalAnalysisImportSessionIndex sessionIndex = (ExternalAnalysisImportSessionIndex)this.indexLayer.openProjectIndex((IProjectId)sapTestInfo.getProjectId(), ExternalAnalysisImportSessionIndex.class, null);
        ExternalAnalysisSessionInfo session = sessionIndex.createSessionInfoForCommit(new ExternalStorageBackendResolvedCommitAndRevision(new CommitDescriptor(TARGET_BRANCH_FOR_COVERAGE_UPLOAD, sapTestInfo.getStartTimestamp()), null, null), null, sapTestInfo.getExecutingUser(), MESSAGE_OF_COVERAGE_UPLOAD, TARGET_PARTITION_FOR_COVERAGE_UPLOAD, false, null);
        ExternalAnalysisImportInfoReport.Builder builder = new ExternalAnalysisImportInfoReport.Builder(null, EReportFormat.TESTWISE_COVERAGE);
        builder.addReport("SAP-Testwise-Coverage", report);
        sessionIndex.insertImportInfos(session, Collections.singletonList(builder.build()));
        session.setCommitted();
        sessionIndex.setSessionInfo(session.getSessionId(), session);
        CCSMAssert.isTrue((boolean)sessionIndex.markSessionAsScheduled(session), (String)"Could not mark session as scheduled.");
        JobDescriptor integrationJob = new JobDescriptor(sapTestInfo.getProjectId(), IntegrateImportedAnalysisResultsTrigger.class, session.getCommit(), "External testwise SAP coverage was downloaded.");
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.indexLayer, integrationJob);
    }

    private void schedulePeriodicalRetry() {
        long timestampNextMinute;
        PeriodicMaintenanceJobRegistry jobRegistry = PeriodicMaintenanceJobRegistry.getInstance();
        boolean periodicTrialAlreadyScheduled = jobRegistry.getScheduledJobs(timestampNextMinute = System.currentTimeMillis() + 60000L).stream().anyMatch(job -> job.getTriggerName().equals(((Object)((Object)this)).getClass().getName()));
        if (!periodicTrialAlreadyScheduled) {
            jobRegistry.addScheduledTrigger(MINUTELY_SCHEDULING_CRON_EXPRESSION, ((Object)((Object)this)).getClass());
        }
    }

    private void unschedulePeriodicalRetry(TemporarySapTestInfoIndex sapTestIndex) throws StorageException {
        if (sapTestIndex.getTestsToBeFetched().isEmpty()) {
            PeriodicMaintenanceJobRegistry.getInstance().removeFirstScheduledTriggerByClass(((Object)((Object)this)).getClass());
        }
    }

    private static void removeFromQueueIfRetriesExceeded(String testKey, TemporarySapTestInfoIndex sapTestIndex, ConQATException e) throws StorageException {
        RETRIES_COUNTER.inc((Object)testKey);
        LogManager.getLogger().error("Failed executing remote function call (RFC) on SAP Server. This was retry #" + RETRIES_COUNTER.getValue((Object)testKey) + ". Will unschedule integration of " + testKey + " after unsuccessful 10 retries. Coverage data will be lost.", (Throwable)e);
        if (RETRIES_COUNTER.getValue((Object)testKey) < 10) {
            return;
        }
        RETRIES_COUNTER.remove((Object)testKey);
        sapTestIndex.removeTestInfo(testKey);
    }
}

