/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis.teamscale_server;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.findings.clangtidy.ClangTidyRunner;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisUtils;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyResultsTransport;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.EClangTidyOutsourcedAnalysisStatus;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.IClangTidyOutsourcedAnalysisExecutionServerAPI;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.teamscale_server.ClangTidyOutsourcedAnalysisSessionsIndex;
import com.teamscale.index.findings.cross_file_analysis.CrossFileFindingsAnalysisBase;
import com.teamscale.index.resource.BasicTokenElementIndex;
import eu.cqse.check.framework.shallowparser.util.ParseLogMessage;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ClangTidyOutsourcedAnalysisPull
extends CrossFileFindingsAnalysisBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration RETRY_INTERVAL = Duration.ofMinutes(10L);
    @DeltaSource(value=ClangTidyOutsourcedAnalysisSessionsIndex.class)
    private KeyDelta changedAnalysisSessions;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ClangTidyOutsourcedAnalysisSessionsIndex sessionsIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCredentialsIndex credentialsProvider;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptions;
    private IClangTidyOutsourcedAnalysisExecutionServerAPI service;
    @DeltaSource(value=BasicTokenElementIndex.class, indexName="basic-token-elements")
    private KeyDelta basicTokenElementIndexDelta;

    public void execute() throws Exception {
        if (this.changedAnalysisSessions.isEmpty()) {
            LOGGER.debug("Received no session. Maybe the push job failed, hence no analysis session was created.");
            return;
        }
        ExternalCredentials executionServerCredentials = ClangTidyOutsourcedAnalysisUtils.getClangTidyAnalysisServiceCredentials(this.serverOptions, (IExternalCredentialsProvider)this.credentialsProvider);
        this.service = IClangTidyOutsourcedAnalysisExecutionServerAPI.generateServiceClient(executionServerCredentials, LOGGER);
        List addedSessionKeys = this.changedAnalysisSessions.getAddedOrChangedKeysAsStrings();
        Map<String, CodeScopeName> codeScopesBySession = this.sessionsIndex.getCodeScopesBySession(addedSessionKeys);
        for (String sessionKey : codeScopesBySession.keySet()) {
            this.checkStatusesAndRequestRescheduleIfRequired(sessionKey);
        }
        HashMap<String, List<IndexFinding>> findingsByAnalysisPath = new HashMap<String, List<IndexFinding>>();
        PairList analyzedPaths = new PairList();
        for (Map.Entry<String, CodeScopeName> codeScopeBySession : codeScopesBySession.entrySet()) {
            String sessionKey = codeScopeBySession.getKey();
            CodeScopeName codeScopeName = codeScopeBySession.getValue();
            List<ClangTidyResultsTransport> analysisResults = this.fetchAnalysisResults(sessionKey);
            ClangTidyOutsourcedAnalysisPull.importParseLogEntries(analysisResults);
            HashSet analyzedPathsInCodeScope = new HashSet();
            analysisResults.forEach(analysisResult -> analyzedPathsInCodeScope.add(analysisResult.uniformPath()));
            Map<String, List<IndexFinding>> findingsByAnalysisPathInCodeScope = ClangTidyOutsourcedAnalysisPull.extractFindingsByAnalysisPath(analysisResults);
            findingsByAnalysisPath.putAll(findingsByAnalysisPathInCodeScope);
            analyzedPaths.add((Object)codeScopeName, analyzedPathsInCodeScope);
        }
        this.storeFindings(findingsByAnalysisPath, (CodeScopeAware<Set<String>>)CodeScopeAware.fromPairList((PairList)analyzedPaths), this.basicTokenElementIndexDelta.getDeletedKeysAsStrings(), "clang-tidy");
    }

    private static Map<String, List<IndexFinding>> extractFindingsByAnalysisPath(List<ClangTidyResultsTransport> analysisResults) {
        HashMap<String, List<IndexFinding>> findingsByAnalysisPathInCodeScope = new HashMap<String, List<IndexFinding>>();
        for (ClangTidyResultsTransport analysisResult : analysisResults) {
            for (ClangTidyResultsTransport.ClangTidyFindingTransport resultFinding : analysisResult.findings()) {
                findingsByAnalysisPathInCodeScope.computeIfAbsent(analysisResult.uniformPath(), k -> new ArrayList()).add(resultFinding.asIndexFinding());
            }
        }
        return findingsByAnalysisPathInCodeScope;
    }

    private static void importParseLogEntries(List<ClangTidyResultsTransport> analysisResults) {
        for (ClangTidyResultsTransport analysisResult : analysisResults) {
            for (ParseLogMessage parseLogMessage : analysisResult.parseLogEntries()) {
                ClangTidyRunner.logParseLogMessageToParseLog(parseLogMessage);
            }
        }
    }

    private @NonNull List<ClangTidyResultsTransport> fetchAnalysisResults(String sessionKey) throws ServiceCallException {
        return this.service.getAnalysisResultsByPath(sessionKey);
    }

    private void checkStatusesAndRequestRescheduleIfRequired(String sessionKey) throws ServiceCallException, RescheduleRequestedException {
        LOGGER.debug("Fetching analysis status for session {}.", (Object)sessionKey);
        if (!this.isAnalysisDone(sessionKey)) {
            throw new RescheduleRequestedException("Waiting for outsourced analysis to finish.", Instant.now().plus(RETRY_INTERVAL));
        }
        LOGGER.debug("Session {} finished analysis. Fetching results.", (Object)sessionKey);
    }

    private boolean isAnalysisDone(String sessionKey) throws ServiceCallException {
        EClangTidyOutsourcedAnalysisStatus state = this.service.getAnalysisStatus(sessionKey);
        switch (state) {
            case SCHEDULED: 
            case RUNNING: {
                LOGGER.debug("Session {} is still in progress.", (Object)sessionKey);
                return false;
            }
            case DONE: {
                LOGGER.debug("Session {} successfully finished analysis.", (Object)sessionKey);
                return true;
            }
            case ERROR: {
                LOGGER.debug("Session {} finished with an error.", (Object)sessionKey);
                return true;
            }
        }
        CCSMAssert.fail((String)("unsupported state " + String.valueOf((Object)state)));
        return false;
    }
}

