/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.eslint;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.configuration.tools.ESLintConfiguration;
import com.teamscale.index.configuration.tools.NodeJsLinterUtils;
import com.teamscale.index.findings.LintFindingsSynchronizerBase;
import com.teamscale.index.findings.eslint.ESLintReportReader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class ESLintFindingsSynchronizer
extends LintFindingsSynchronizerBase {
    public static final String ALLOW_EXECUTABLE_CONFIG_FILE_FLAG = "com.teamscale.allow-executable-lint-config-file";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FINDING_PARTITION = "eslint-internal";
    private static final String BUNDLED_ESLINT_PATH = "eslint/bin/eslint.js";
    private static final Set<String> SUPPORTED_FILE_EXTENSIONS = Stream.concat(Arrays.stream(ELanguage.JAVASCRIPT.getFileExtensions()), Stream.of("html")).collect(Collectors.toSet());
    public static final String SETTINGS_FILE_PARAMETER = "settings-file";
    public static final String ACTIVE_FINDING_GROUP_NAMES_PARAMETER = "active-finding-group-names";
    private static final String ESLINTRC_JSON = ".eslintrc.json";
    private static final List<String> ALLOWED_SETTING_FILE_EXTENSIONS = Arrays.asList(".json", ".yml", ".yaml");
    @StepParameter(value="settings-file", optional=true)
    private CodeScopeAware<String> settingsFile = CodeScopeAware.empty();
    @StepParameter(value="active-finding-group-names")
    private CodeScopeAware<List<String>> activeESLintRules;

    public ESLintFindingsSynchronizer() {
        super(FINDING_PARTITION, SUPPORTED_FILE_EXTENSIONS);
    }

    private static void assertConfigFileExtensionsIsAllowed(String configurationFilePath) {
        boolean allowExecutableSettingsFile = Boolean.getBoolean(ALLOW_EXECUTABLE_CONFIG_FILE_FLAG);
        if (StringUtils.isEmpty((String)configurationFilePath) || allowExecutableSettingsFile) {
            return;
        }
        if (!StringUtils.endsWithOneOf((String)configurationFilePath.toLowerCase(), (String[])((String[])CollectionUtils.toArray(ALLOWED_SETTING_FILE_EXTENSIONS, String.class)))) {
            throw new SecurityException("Invalid settings file extension for ESLint: '" + configurationFilePath + "'. For security reasons, only the file extensions " + String.valueOf(ALLOWED_SETTING_FILE_EXTENSIONS) + " are enabled by default. Use the JVM flag -Dcom.teamscale.allow-executable-lint-config-file=true to allow arbitrary (potentially executable) setting file extensions like '.js' (discouraged!)");
        }
    }

    private static boolean checkSettingsFile(String settingsFile) {
        if (settingsFile == null || settingsFile.isEmpty()) {
            return false;
        }
        if (!FileSystemUtils.isReadableFile((Path)Paths.get(settingsFile, new String[0]))) {
            LOGGER.error("Cannot read settings file: {}", (Object)settingsFile);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Optional<String> executeLint(Collection<BasicTokenElementInfo> tokenElements, CodeScopeName codeScopeName) throws ConQATException {
        try (TemporaryDirectory tmpDir = ESLintFindingsSynchronizer.getTempDirectory((String)"files");){
            CanonicalFile analysisDir = new CanonicalFile(tmpDir.getPath().toFile());
            List<String> relativeFilePaths = ESLintFindingsSynchronizer.createTemporaryFiles(analysisDir, tokenElements, (FunctionWithException<String, String, ConQATException>)FunctionWithException.identity());
            if (ESLintFindingsSynchronizer.shouldSkipExecution(relativeFilePaths)) {
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            File eslintDir = ESLintConfiguration.getEslintDirectory();
            Optional<String> result = this.execute(eslintDir, (File)analysisDir, tokenElements, (String)this.settingsFile.getValueWithDefault(codeScopeName), codeScopeName);
            Optional<String> optional = result.map(report -> ESLintFindingsSynchronizer.postProcessFindingResults(report, analysisDir));
            return optional;
        }
        catch (IOException | ConQATException e) {
            throw new ConQATException("Failed to execute ESLint for " + ESLintFindingsSynchronizer.getErrorMessage(tokenElements), e);
        }
    }

    private static boolean shouldSkipExecution(List<String> relativeFilePaths) {
        for (String path : relativeFilePaths) {
            List segments = StringUtils.splitWithEscapeCharacter((String)path, (Character)Character.valueOf(File.separatorChar));
            boolean isDotDirectory = segments.stream().anyMatch(s -> s.startsWith("."));
            if (isDotDirectory) continue;
            return false;
        }
        return true;
    }

    private Optional<String> execute(File eslintDir, File analysisDir, Collection<BasicTokenElementInfo> tokenElements, String settingsFile, CodeScopeName codeScopeName) throws ConQATException, IOException {
        ESLintFindingsSynchronizer.assertConfigFileExtensionsIsAllowed(settingsFile);
        ESLintFindingsSynchronizer.assertConfigFileIsInsideWorkingDir(settingsFile);
        File eslintConfigFile = this.copyConfigFiles(analysisDir, settingsFile, codeScopeName);
        ProcessBuilder builder = new ProcessBuilder(ESLintFindingsSynchronizer.getESLintCommand(eslintDir, analysisDir, eslintConfigFile));
        builder.directory(analysisDir);
        builder.environment().put("NODE_PATH", eslintDir.getAbsolutePath());
        builder.environment().put("ESLINT_USE_FLAT_CONFIG", "false");
        ProcessUtils.ExecutionResult executionResult = ProcessUtils.execute((ProcessBuilder)builder);
        String errorOutput = executionResult.getStderr();
        if (errorOutput != null && !errorOutput.trim().isEmpty()) {
            if (errorOutput.contains("No files matching the pattern") && settingsFile != null) {
                List elementPaths = CollectionUtils.map(tokenElements, BasicTokenElementInfo::getUniformPath);
                elementPaths.sort(Comparator.naturalOrder());
                LOGGER.warn("You are using the custom ESLint configuration {} which does not include all compatible files. Please update the configuration accordingly. Otherwise no findings will be produced for the following files:\n{}\n", (Object)settingsFile, (Object)elementPaths);
                return Optional.empty();
            }
            throw new ConQATException("ESLint error: " + errorOutput);
        }
        String output = executionResult.getStdout();
        if (output == null || output.trim().isEmpty()) {
            throw new ConQATException("No output received from ESLint.");
        }
        return Optional.of(output);
    }

    private static void assertConfigFileIsInsideWorkingDir(@Nullable String configurationFilePath) {
        boolean settingsFileOutsideConfigDirectories;
        if (StringUtils.isEmpty((String)configurationFilePath)) {
            return;
        }
        Path eslintConfigFilePath = Path.of(new File(configurationFilePath).toURI()).normalize();
        List configDirectories = new ArrayList<Path>();
        if (FileSystemUtils.isDevModeOrJunitTest()) {
            configDirectories.add(FileSystemUtils.getTmpDir().toPath());
        } else {
            configDirectories = TeamscaleInstallationUtils.getConfigDirectories();
        }
        if (settingsFileOutsideConfigDirectories = configDirectories.stream().noneMatch(eslintConfigFilePath::startsWith)) {
            String configDirs = StringUtils.concat(configDirectories, (String)",");
            throw new SecurityException("Invalid path for EsLint settings file: '" + configurationFilePath + ". For security reasons, the file must be placed inside the config directory of Teamscale (" + configDirs + ")");
        }
    }

    private static String postProcessFindingResults(String result, CanonicalFile rootDirectory) {
        String tempDirectoryPath = rootDirectory.getCanonicalPath().replaceAll("\\\\", "/");
        return result.replaceAll(tempDirectoryPath + "/", "");
    }

    private static String getErrorMessage(Collection<BasicTokenElementInfo> tokenElementInfos) {
        return "Failed to execute ESLint for " + String.valueOf(CollectionUtils.map(tokenElementInfos, BasicTokenElementInfo::getUniformPath));
    }

    private File copyConfigFiles(File analysisDir, String settingsFile, CodeScopeName codeScopeName) throws IOException, JsonSerializationException {
        Resource.of(((Object)((Object)this)).getClass(), (String)"tsconfig.json").copyTo(new File(analysisDir, "tsconfig.json"));
        if (ESLintFindingsSynchronizer.checkSettingsFile(settingsFile)) {
            File sourceSettingsFile = new File(settingsFile);
            File targetFile = new File(analysisDir, sourceSettingsFile.getName());
            FileSystemUtils.copyFile((Path)sourceSettingsFile.toPath(), (Path)targetFile.toPath());
            return targetFile;
        }
        return this.generateProjectSpecificConfigFile(analysisDir, codeScopeName);
    }

    private File generateProjectSpecificConfigFile(File analysisDir, CodeScopeName codeScopeName) throws JsonSerializationException, IOException {
        File targetFile = new File(analysisDir, ESLINTRC_JSON);
        ArrayList<String> eslintRules = new ArrayList<String>();
        ArrayList<String> tsRules = new ArrayList<String>();
        ArrayList<String> reactRules = new ArrayList<String>();
        ArrayList<String> jsxA11yRules = new ArrayList<String>();
        ArrayList<String> angularRules = new ArrayList<String>();
        ArrayList<String> angularTemplateRules = new ArrayList<String>();
        ArrayList<String> securityRules = new ArrayList<String>();
        this.initializeActiveAnalysisRules(eslintRules, tsRules, reactRules, jsxA11yRules, angularRules, angularTemplateRules, securityRules, codeScopeName);
        String jsonString = Resource.of(((Object)((Object)this)).getClass(), (String)"eslintrc.json").getContent();
        ObjectNode rootNode = (ObjectNode)JsonUtils.deserializeFromJson((String)jsonString);
        JsonNode overrides = rootNode.findValue("overrides");
        ObjectNode jsRulesOverride = (ObjectNode)overrides.get(0);
        ObjectNode jsxRulesOverride = (ObjectNode)overrides.get(1);
        ObjectNode tsRulesOverride = (ObjectNode)overrides.get(2);
        ObjectNode tsxRulesOverride = (ObjectNode)overrides.get(3);
        ObjectNode htmlRulesOverride = (ObjectNode)overrides.get(4);
        ESLintFindingsSynchronizer.attachRulesToNode(eslintRules, rootNode);
        ESLintFindingsSynchronizer.attachRulesToNode(Stream.of(reactRules, angularRules, securityRules).flatMap(Collection::stream).toList(), jsRulesOverride);
        ESLintFindingsSynchronizer.attachRulesToNode(Stream.of(reactRules, jsxA11yRules, securityRules).flatMap(Collection::stream).toList(), jsxRulesOverride);
        ArrayList rules = CollectionUtils.unionList(tsRules, (Collection[])new Collection[]{reactRules, securityRules});
        List<String> overlappingJsRules = ESLintFindingsSynchronizer.extractOverlappingRules(rules, eslintRules);
        ESLintFindingsSynchronizer.attachRulesToNode(CollectionUtils.unionList((Collection)rules, (Collection[])new Collection[]{angularRules}), tsRulesOverride, overlappingJsRules);
        ESLintFindingsSynchronizer.attachRulesToNode(CollectionUtils.unionList((Collection)rules, (Collection[])new Collection[]{jsxA11yRules}), tsxRulesOverride, overlappingJsRules);
        List<String> otherRules = CollectionUtils.unionSet(eslintRules, (Collection[])new Collection[]{tsRules, reactRules, jsxA11yRules, securityRules}).stream().toList();
        ESLintFindingsSynchronizer.attachRulesToNode(angularTemplateRules, htmlRulesOverride, otherRules);
        JsonUtils.getObjectMapper().writeValue(targetFile, (Object)rootNode);
        return targetFile;
    }

    private static List<String> extractOverlappingRules(List<String> tsRules, List<String> eslintRules) {
        return tsRules.stream().flatMap(tsRule -> eslintRules.stream().filter(eslintRule -> tsRule.endsWith("/" + eslintRule))).toList();
    }

    private void initializeActiveAnalysisRules(List<String> eslintRules, List<String> tsRules, List<String> reactRules, List<String> jsxA11yRules, List<String> angularRules, List<String> angularTemplateRules, List<String> securityRules, CodeScopeName codeScopeName) {
        for (String rule : (List)this.activeESLintRules.getValue(codeScopeName)) {
            if (rule.startsWith("@typescript-eslint/")) {
                tsRules.add(rule);
                continue;
            }
            if (rule.startsWith("react/")) {
                reactRules.add(rule);
                continue;
            }
            if (rule.startsWith("jsx-a11y/")) {
                jsxA11yRules.add(rule);
                continue;
            }
            if (rule.startsWith("@angular-eslint/template/")) {
                angularTemplateRules.add(rule);
                continue;
            }
            if (rule.startsWith("@angular-eslint/")) {
                angularRules.add(rule);
                continue;
            }
            if (rule.startsWith("security/")) {
                securityRules.add(rule);
                continue;
            }
            eslintRules.add(rule);
        }
    }

    private static void attachRulesToNode(List<String> rules, ObjectNode node) {
        ObjectNode rulesNode = JsonUtils.getObjectMapper().createObjectNode();
        rules.forEach(rule -> rulesNode.set(rule, ESLintFindingsSynchronizer.getNodeForRule(rule)));
        node.set("rules", (JsonNode)rulesNode);
    }

    private static void attachRulesToNode(List<String> rules, ObjectNode node, List<String> rulesToDisable) {
        ESLintFindingsSynchronizer.attachRulesToNode(rules, node);
        ObjectNode rulesNode = (ObjectNode)node.get("rules");
        rulesToDisable.forEach(rule -> rulesNode.set(rule, (JsonNode)new TextNode("off")));
    }

    private static JsonNode getNodeForRule(String rule) {
        if (rule.equals("new-cap")) {
            return ESLintFindingsSynchronizer.getNodeForNewCapRule();
        }
        return new TextNode("error");
    }

    private static ArrayNode getNodeForNewCapRule() {
        ArrayNode arrayNode = JsonUtils.getObjectMapper().createArrayNode();
        arrayNode.add((JsonNode)new TextNode("error"));
        ObjectNode objectNode = JsonUtils.getObjectMapper().createObjectNode();
        ArrayNode exceptionsNode = JsonUtils.getObjectMapper().createArrayNode();
        exceptionsNode.add("Component");
        exceptionsNode.add("ViewChild");
        exceptionsNode.add("Input");
        exceptionsNode.add("Output");
        objectNode.set("capIsNewExceptions", (JsonNode)exceptionsNode);
        arrayNode.add((JsonNode)objectNode);
        return arrayNode;
    }

    @Override
    protected ListMap<String, IndexFinding> parseReport(String reportContent) throws StorageException {
        ESLintReportReader reportReader = new ESLintReportReader(this.pathLookupIndex.createLoggingPreloadedLookup());
        try {
            return reportReader.parseReport(reportContent);
        }
        catch (ConQATException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static List<String> getESLintCommand(File eslintDirectory, File folder, File eslintConfigFile) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(NodeJsLinterUtils.NODE_EXECUTABLE);
        command.add(new File(eslintDirectory, BUNDLED_ESLINT_PATH).getAbsolutePath());
        command.add("--format");
        command.add("checkstyle");
        command.add("--no-eslintrc");
        command.add("--config");
        command.add(eslintConfigFile.getAbsolutePath());
        command.add(folder.getAbsolutePath());
        return command;
    }
}

