/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.repository.FindingIssuesMappingIndex;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.repository.RepositoryCommitMappingIndexBase;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.CollectionUtils;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class FindingIssueMappingSynchronizer
extends ChangeProcessorAnalysisStep {
    @DeltaSource(value=RepositoryCommitIssueMappingIndex.class)
    private KeyDelta issueCommitDelta;
    @DeltaSource(value=FindingChurnListIndex.class)
    private KeyDelta findingsChurnListDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingChurnListIndex findingChurnListIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingIssuesMappingIndex findingToIssuesMappingIndex;

    public void execute() throws Exception {
        if (this.findingsChurnListDelta.isEmpty() || this.issueCommitDelta.isEmpty()) {
            return;
        }
        FindingChurnList churnList = (FindingChurnList)this.findingChurnListIndex.getEntry(this.getSchedulingCommit());
        if (churnList == null) {
            return;
        }
        ArrayList<String> affectedFindingsIds = new ArrayList<String>();
        affectedFindingsIds.addAll(CollectionUtils.map(churnList.getAddedFindings(), TrackedFinding::getId));
        affectedFindingsIds.addAll(CollectionUtils.map(churnList.getRemovedFindings(), TrackedFinding::getId));
        Set<TeamscaleIssueId> affectedIssueIds = RepositoryCommitMappingIndexBase.extractIssueIdsFromStoreKeys((List<StorageKey>)this.issueCommitDelta.getAddedOrChangedKeys()).stream().map(TeamscaleIssueId::fromInternalId).collect(Collectors.toSet());
        this.findingToIssuesMappingIndex.storeFindingIssueMapping(affectedFindingsIds, affectedIssueIds);
    }
}

