/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.updater;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.issues.updater.IssueUpdaterBase;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class IssueMetricsUpdater
extends IssueUpdaterBase {
    public static final String WORK_ITEM_SIZE_METRIC_NAME = "-spec-item-size-";
    private static final String[] ALL_METRICS = new String[]{"-spec-item-size-"};
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="work-item-metrics")
    private MetricsIndex metricsIndex;

    @Override
    protected void performUpdate(List<SpecItem> updatedItems, List<TeamscaleIssueId> deletedItemIds) throws Exception {
        this.updateWorkItemSize(updatedItems);
        this.removeDeletedEntries(deletedItemIds);
    }

    private void removeDeletedEntries(Collection<TeamscaleIssueId> deletedItemIds) throws StorageException {
        List deletedUniformPaths = deletedItemIds.stream().map(TeamscaleIssueId::toPossibleUniformPaths).flatMap(Collection::stream).collect(Collectors.toList());
        this.metricsIndex.removeEntriesForUniformPaths(deletedUniformPaths, ALL_METRICS);
    }

    private void updateWorkItemSize(Collection<? extends TeamscaleIssue> updatedItems) throws StorageException {
        PairList pairs = (PairList)updatedItems.stream().map(item -> new Pair((Object)item.getUniformPath().toString(), (Object)item.toString().length())).collect(PairList.toPairList());
        this.metricsIndex.setMetricValues(pairs, WORK_ITEM_SIZE_METRIC_NAME);
    }
}

