/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.google.common.base.Stopwatch;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.MergeBaseResolver;
import com.teamscale.index.repository.git.GitCommandLineToolBase;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.options.Option;
import org.jspecify.annotations.NonNull;

public class MergeBaseResolverTool
extends GitCommandLineToolBase {
    private String sourceBranch = null;
    private String targetBranch = null;

    @Option(longName="source", description="merge source branch (from)")
    public void setSourceBranch(String branch) {
        this.sourceBranch = branch;
    }

    @Option(longName="target", description="optional merge target branch (to)")
    public void setTargetBranch(String branch) {
        this.targetBranch = branch;
    }

    protected void run() throws Exception {
        if (this.targetBranch == null) {
            this.targetBranch = this.defaultBranchName;
        }
        GitRepositoryConnection connection = this.createGitRepositoryConnection();
        CommitTree commitTreeIndex = this.expandCommitTree(connection, true);
        CommitDescriptorIndex commitDescriptorIndex = this.createCommitDescriptorIndex(commitTreeIndex);
        MergeBaseInfo mergeBase = this.calculateMergeBase(commitDescriptorIndex);
        CommitDescriptor mergeBaseCommit = mergeBase.getMergeBase();
        ICommitTreeNode node = commitTreeIndex.getNodeByBranchAndAdjustedTimestamp(mergeBaseCommit.getBranchName(), mergeBaseCommit.getTimestamp());
        MergeBaseResolverTool.printInfo((String)("Merge base: " + String.valueOf(mergeBaseCommit) + " " + node.getRevision().getRevision()));
    }

    private MergeBaseInfo calculateMergeBase(CommitDescriptorIndex commitDescriptorIndex) throws StorageException, RepositoryException, CommitResolutionException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Optional<MergeBaseInfo> mergeBaseInfo = MergeBaseResolver.computeMergeBaseInfo((CommitDescriptor)commitDescriptorIndex.getLatestCommitForBranch(this.sourceBranch).orElseThrow(() -> new RepositoryException("Source branch not found: " + this.sourceBranch)), (CommitDescriptor)commitDescriptorIndex.getLatestCommitForBranch(this.targetBranch).orElseThrow(() -> new RepositoryException("Target branch not found: " + this.targetBranch)), commitDescriptorIndex);
        MergeBaseResolverTool.printInfo((String)("Merge base calculation took " + (double)stopwatch.elapsed().toMillis() / 1000.0 + " sec"));
        return mergeBaseInfo.orElseThrow(() -> new RepositoryException("No merge base found"));
    }

    private @NonNull CommitDescriptorIndex createCommitDescriptorIndex(CommitTree commitTreeIndex) throws StorageException {
        CommitDescriptorIndex commitDescriptorIndex = new CommitDescriptorIndex((IStore)new InMemoryStore());
        for (CommitTreeNode node2 : CollectionUtils.sort((Collection)commitTreeIndex.getAllNodes(), Comparator.comparingLong(node -> node.getAdjustedCommitDescriptor().getTimestamp()))) {
            commitDescriptorIndex.insertCommit(MergeBaseResolverTool.nodeToParentedCommitDescriptor(node2));
        }
        return commitDescriptorIndex;
    }

    private static ParentedCommitDescriptor nodeToParentedCommitDescriptor(CommitTreeNode node) {
        List parentCommits = CollectionUtils.map((Collection)node.getParents(), MergeBaseResolverTool::nodeToCommitDescriptor);
        if (node.getInjectedParent() != null) {
            parentCommits.add(node.getInjectedParent());
        }
        return new ParentedCommitDescriptor(MergeBaseResolverTool.nodeToCommitDescriptor(node), parentCommits);
    }

    private static CommitDescriptor nodeToCommitDescriptor(CommitTreeNode node) {
        return node.getAdjustedCommitDescriptor();
    }

    public static void main(String[] args) throws Exception {
        LoggingUtils.initLogger();
        MergeBaseResolverTool.execute(MergeBaseResolverTool::new, (String[])args);
    }
}

