/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v123_compile_commands;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;

public enum V123ELanguage {
    JAVA("Java", true, "java"),
    CPP("C++", true, "cpp", "hpp", "cxx", "hxx", "cc", "hh", "h", "inc", "inl"),
    C("C", true, "c", "h", "inc"),
    OPEN_CL("OpenCL C/C++", true, "cl"),
    RUST("Rust", true, "rs"),
    VB("Visual Basic", false, "vb", "frm", "cls", "bas"),
    COBOL("COBOL", false, "cbl", "cob", "cobol", "cpy", "eco"),
    CS("C#", true, "cs"),
    ABAP("ABAP", false, "abap"),
    ABAP_DDIC("ABAP Dictionary", false, "abap_ddic"),
    ADA("Ada", false, "ada", "ads", "adb"),
    TEXT("Plain Text", false, "txt"),
    XML("XML", true, "xml", "xsl", "xslt", "architecture", "cqb", "csproj", "config", "prj"),
    SQLSCRIPT("HANA SQLScript", false, "sql", "hdbprocedure", "hdbfunction", "hdbscalarfunction", "hdbtablefunction"),
    HANA_VIEW("HANA View", true, "analyticview", "attributeview", "calculationview"),
    PLSQL("PL/SQL", false, "sql", "pks", "pkb", "trg", "fnc", "typ", "tyb", "prc", "plsql"),
    PYTHON("Python", true, "py"),
    TSQL("Transact-SQL", false, "tsql", "sql"),
    MATLAB("Matlab", true, "m"),
    PHP("PHP", true, "php", "php3", "php4", "php5"),
    JAVASCRIPT("JavaScript/TypeScript", true, "js", "sj", "jsx", "ts", "tsx"),
    LINE("Line-based Text", false, new String[0]),
    DELPHI("Delphi", false, "pas", "dpr"),
    IEC61131("IEC 61131-3 ST", true, "pu", "sv", "st", "scl", "pou", "dt", "var", "tu"),
    FORTRAN("Fortran", false, "f", "for", "f77", "f90", "f95", "f03"),
    XTEND("Xtend", true, "xtend"),
    SWIFT("Swift", true, "swift"),
    OCAML("OCaml", true, "ml", "mli"),
    OSCRIPT("OScript", true, "osx", "lxe", "os"),
    GROOVY("Groovy", true, "groovy"),
    NL_REQUIREMENTS("Natural Language Requirements", false, new String[0]),
    NL_TESTS("Natural Language Tests", false, "nltests"),
    NL_ISSUES("Natural Language Issues", false, new String[0]),
    SIMULINK("Simulink and Stateflow", false, "mdl", "slx", "sldd"),
    GOSU("Gosu", true, "gsp", "gs", "gsx", "gr", "grs"),
    KOTLIN("Kotlin", true, "kt", "kts", "ktm"),
    OBJECTIVE_C("Objective-C", true, "m", "h"),
    OBJECTIVE_CPP("Objective-C++", true, "mm", "h", "inc", "inl"),
    JAVADOC("JavaDoc", true, new String[0]),
    GO("Go", true, "go"),
    ABAP_CDS("ABAP CDS", false, "abap_cds", "abap_ddlx", "asddls", "asddlxs", "acds"),
    POWERSHELL("Powershell", false, "ps1", "psd1", "psm1");

    private static final EnumSet<V123ELanguage> LANGUAGES_WITHOUT_METHODS;
    private static final EnumSet<V123ELanguage> LANGUAGES_WITH_PREPROCESSOR_EXPANSIONS;
    public static final Set<V123ELanguage> HIDDEN_LANGUAGES;
    private static final Map<String, EnumSet<V123ELanguage>> EXTENSION_2_LANGUAGE_MAP;
    private final String readableName;
    private final boolean caseSensitive;
    private final String[] extensions;

    private V123ELanguage(String readableName, boolean caseSensitive, String ... extensions) {
        this.readableName = readableName;
        this.caseSensitive = caseSensitive;
        this.extensions = extensions;
    }

    public static boolean languageHasMethods(V123ELanguage language) {
        return !LANGUAGES_WITHOUT_METHODS.contains((Object)language);
    }

    public static V123ELanguage[] getUserVisibleLanguages() {
        if (!EFeatureToggle.SHOW_HIDDEN_LANGUAGES.isEnabled()) {
            return (V123ELanguage[])Arrays.stream(V123ELanguage.values()).filter(language -> !HIDDEN_LANGUAGES.contains(language)).toArray(V123ELanguage[]::new);
        }
        return V123ELanguage.values();
    }

    static {
        LANGUAGES_WITHOUT_METHODS = EnumSet.of(ABAP_DDIC, LINE, TEXT, XML, HANA_VIEW);
        LANGUAGES_WITH_PREPROCESSOR_EXPANSIONS = EnumSet.of(C, CPP, OBJECTIVE_C, OBJECTIVE_CPP);
        HIDDEN_LANGUAGES = EnumSet.of(RUST);
        EXTENSION_2_LANGUAGE_MAP = new HashMap<String, EnumSet<V123ELanguage>>();
    }
}

