/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.precommit;

import com.teamscale.core.user.User;
import com.teamscale.index.monitoring.prometheus.UniqueObservationGauge;
import com.teamscale.index.precommit.PreCommitUploadData;
import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import io.prometheus.metrics.core.datapoints.GaugeDataPoint;
import io.prometheus.metrics.core.metrics.Gauge;
import io.prometheus.metrics.core.metrics.Summary;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.Label;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@Index(name="precommit-statistics", options={EStorageOption.COMPRESSED})
public class PrecommitStatisticsIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "precommit-statistics";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Summary PRECOMMIT_LATENCY = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("precommit_latency_seconds")).help("The full time it takes until a user receives analysis results on a pre-commit analysis")).labelNames(new String[]{"project", "reason"})).numberOfAgeBuckets(24).maxAgeSeconds(Duration.ofDays(1L).toMillis()).quantile(0.25, 0.005).quantile(0.5, 0.005).quantile(0.75, 0.005).register();
    private static final Summary PRECOMMIT_POLLING_TOTAL = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("precommit_polling")).help("The number of polling events it took until a pre-commit task was complete.")).labelNames(new String[]{"project"})).numberOfAgeBuckets(24).maxAgeSeconds(Duration.ofDays(1L).toMillis()).quantile(0.25, 0.005).quantile(0.5, 0.005).quantile(0.75, 0.005).register();
    private static final Gauge PRECOMMIT_OPEN_TASKS_TOTAL = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("precommit_open_tasks")).help("The number of open pre-commit tasks.")).labelNames(new String[]{"project"})).register();
    private static final Summary PRECOMMIT_CONTENT_TOTAL = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("precommit_content")).help("The content of a finished pre-commit.")).labelNames(new String[]{"project", "type"})).numberOfAgeBuckets(24).maxAgeSeconds(Duration.ofDays(1L).toMillis()).quantile(0.25, 0.005).quantile(0.5, 0.005).quantile(0.75, 0.005).register();
    private static final UniqueObservationGauge<String> PRECOMMIT_UNIQUE_USERS = (UniqueObservationGauge)((UniqueObservationGauge.Builder)((UniqueObservationGauge.Builder)((UniqueObservationGauge.Builder)UniqueObservationGauge.builder().name("precommit_unique_users_last_five_minutes")).help("The count of unique users of the pre-commit service in the last 5 minutes.")).labelNames(new String[]{"project"})).interval(Duration.ofMinutes(5L)).register();
    private final ValueIndex<PrecommitTaskInfo> delegate;
    private final IStore store;

    public PrecommitStatisticsIndex(IStore store) {
        this.store = store;
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    @VisibleForTesting
    public static void resetOpenTasksCounter() {
        for (GaugeSnapshot.GaugeDataPointSnapshot dataPoint : PRECOMMIT_OPEN_TASKS_TOTAL.collect().getDataPoints()) {
            PRECOMMIT_OPEN_TASKS_TOTAL.remove((String[])dataPoint.getLabels().stream().map(Label::getValue).toArray(String[]::new));
        }
    }

    private synchronized void initializeOpenTasksMetric() {
        try {
            CounterSet openTasksPerProject = new CounterSet();
            this.delegate.getAllEntries().extractSecondList().stream().filter(info -> info.taskTerminationInstant == null).forEach(info -> openTasksPerProject.inc((Object)info.publicProjectId));
            openTasksPerProject.forEach(pair -> ((GaugeDataPoint)PRECOMMIT_OPEN_TASKS_TOTAL.labelValues(new String[]{((PublicProjectId)pair.getFirst()).projectId})).set((double)((Integer)pair.getSecond()).intValue()));
        }
        catch (StorageException e) {
            LOGGER.error("Could not initialize open tasks metric.", (Throwable)e);
        }
    }

    public void storeNewTask(InternalProjectId internalProjectId, PublicProjectId publicProjectId, String token, User user, PreCommitUploadData uploadData, String repositoryParentBranchName) throws StorageException {
        this.initializeOpenTasksMetric();
        this.delegate.setValue(PrecommitStatisticsIndex.buildKey(internalProjectId, token, user), (Object)new PrecommitTaskInfo(internalProjectId, publicProjectId, token, user, uploadData, repositoryParentBranchName));
        ((GaugeDataPoint)PRECOMMIT_OPEN_TASKS_TOTAL.labelValues(new String[]{publicProjectId.projectId})).inc();
        PRECOMMIT_UNIQUE_USERS.labelValues(publicProjectId.projectId).observe(user.getUsername());
    }

    public void terminateTask(InternalProjectId internalProjectId, String token, User user, EPrecommitTaskTerminationReason terminationReason) throws StorageException {
        this.initializeOpenTasksMetric();
        Optional<PrecommitTaskInfo> optPrecommitTask = this.executeTask(internalProjectId, token, user, "end of precommit task", entry -> entry.terminateTask(terminationReason));
        if (optPrecommitTask.isPresent()) {
            this.processPrometheusMonitoring(optPrecommitTask.get());
        }
    }

    private void processPrometheusMonitoring(PrecommitTaskInfo precommitTask) {
        if (precommitTask.taskTerminationReason == null) {
            return;
        }
        String projectName = precommitTask.publicProjectId.projectId;
        Duration taskDuration = Duration.between(precommitTask.taskCreationInstant, precommitTask.taskTerminationInstant);
        ((DistributionDataPoint)PRECOMMIT_LATENCY.labelValues(new String[]{projectName, precommitTask.taskTerminationReason.toString()})).observe((double)taskDuration.toMillis() / 1000.0);
        ((DistributionDataPoint)PRECOMMIT_POLLING_TOTAL.labelValues(new String[]{projectName})).observe((double)precommitTask.numberOfPolls);
        ((GaugeDataPoint)PRECOMMIT_OPEN_TASKS_TOTAL.labelValues(new String[]{projectName})).dec();
        ((DistributionDataPoint)PRECOMMIT_CONTENT_TOTAL.labelValues(new String[]{projectName, "new_or_changed_files"})).observe((double)precommitTask.numberOfNewOrChangedFiles);
        ((DistributionDataPoint)PRECOMMIT_CONTENT_TOTAL.labelValues(new String[]{projectName, "deleted_files"})).observe((double)precommitTask.numberOfDeletedFiles);
        ((DistributionDataPoint)PRECOMMIT_CONTENT_TOTAL.labelValues(new String[]{projectName, "chars"})).observe((double)precommitTask.numberOfContentChars);
    }

    public void logPollingEvent(InternalProjectId internalProjectId, String token, User user) throws StorageException {
        this.executeTask(internalProjectId, token, user, "polling event of precommit task", PrecommitTaskInfo::incrementPolls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<PrecommitTaskInfo> executeTask(InternalProjectId internalProjectId, String token, User user, String readableTaskName, Consumer<PrecommitTaskInfo> task) throws StorageException {
        String key = PrecommitStatisticsIndex.buildKey(internalProjectId, token, user);
        Lock lock = this.store.obtainLock(internalProjectId.toString());
        lock.lock();
        try {
            PrecommitTaskInfo entry = (PrecommitTaskInfo)this.delegate.getValue(key);
            if (entry == null) {
                LOGGER.warn("Could not log " + readableTaskName + " " + token + " for user " + String.valueOf(user) + " (did not find initial task log entry)");
                Optional<PrecommitTaskInfo> optional = Optional.empty();
                return optional;
            }
            task.accept(entry);
            this.delegate.setValue(key, (Object)entry);
            Optional<PrecommitTaskInfo> optional = Optional.of(entry);
            return optional;
        }
        finally {
            lock.unlock();
        }
    }

    private static String buildKey(InternalProjectId internalProjectId, String token, User user) {
        return internalProjectId.toString() + "!#!" + user.getUsername() + "!#!" + token;
    }

    public UnmodifiableList<PrecommitTaskInfo> getAllPreCommitTasks() throws StorageException {
        return CollectionUtils.asUnmodifiable((List)this.delegate.getAllEntries().extractSecondList());
    }

    @IndexValueClass
    public static class PrecommitTaskInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final InternalProjectId projectId;
        public final PublicProjectId publicProjectId;
        public final String precommitTaskToken;
        public final String username;
        public final int numberOfNewOrChangedFiles;
        public final int numberOfDeletedFiles;
        public final long numberOfContentChars;
        public final String repositoryParentBranchName;
        private int numberOfPolls = 0;
        public final Instant taskCreationInstant;
        private @Nullable Instant taskTerminationInstant;
        private @Nullable EPrecommitTaskTerminationReason taskTerminationReason;

        private PrecommitTaskInfo(InternalProjectId internalProjectId, PublicProjectId publicProjectId, String precommitTaskToken, User user, PreCommitUploadData uploadData, String repositoryParentBranchName) {
            this.projectId = internalProjectId;
            this.precommitTaskToken = precommitTaskToken;
            this.username = user.getUsername();
            this.repositoryParentBranchName = repositoryParentBranchName;
            this.numberOfNewOrChangedFiles = uploadData.getUniformPathToContentMap().size();
            this.numberOfDeletedFiles = uploadData.getDeletedUniformPaths().size();
            this.numberOfContentChars = uploadData.getUniformPathToContentMap().values().stream().mapToLong(String::length).sum();
            this.taskCreationInstant = Instant.now();
            this.publicProjectId = publicProjectId;
        }

        private void incrementPolls() {
            ++this.numberOfPolls;
        }

        private void terminateTask(EPrecommitTaskTerminationReason terminationReason) {
            this.taskTerminationInstant = Instant.now();
            this.taskTerminationReason = terminationReason;
        }

        public @Nullable Instant getTaskTerminationInstant() {
            return this.taskTerminationInstant;
        }

        public int getNumberOfPolls() {
            return this.numberOfPolls;
        }

        public @Nullable EPrecommitTaskTerminationReason getTaskTerminationReason() {
            return this.taskTerminationReason;
        }
    }

    @IndexValueClass
    public static enum EPrecommitTaskTerminationReason {
        SUCCESSFUL_TERMINATION,
        PRECOMMIT_BRANCH_PURGED;

    }
}

