/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.cppcheck;

import com.teamscale.commons.service.XmlSerializationUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.configuration.tools.message.CppcheckMessageManager;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.index.upload.cppcheck.data.CppcheckError;
import com.teamscale.index.upload.cppcheck.data.CppcheckLocation;
import com.teamscale.index.upload.cppcheck.data.CppcheckResults;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.Nullable;

public class CppcheckReportParser
extends FindingCollectingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private CppcheckResults results;
    private CppcheckMessageManager messageManager;

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            this.results = (CppcheckResults)XmlSerializationUtils.deserializeFromXML((String)report, CppcheckResults.class);
            this.messageManager = CppcheckMessageManager.getInstance();
        }
        catch (IOException e) {
            throw new ReportParserException("Error when parsing report.", (Throwable)e);
        }
        catch (ProjectConfigurationException exception) {
            throw new ReportParserException("Problem occured when configuring message manager: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    protected void collectFindings() throws StorageException {
        CCSMAssert.isNotNull((Object)this.results);
        for (CppcheckError error : this.results.getErrors()) {
            this.addFindingFor(error);
        }
    }

    private void addFindingFor(CppcheckError error) throws StorageException {
        CppcheckLocation primaryLocation = error.getPrimaryLocation();
        if (primaryLocation == null) {
            LOGGER.warn("No location provided for Cppcheck error with id '" + error.getId() + "'.");
            return;
        }
        Optional<String> pathInTeamscale = this.resolvePath(primaryLocation.getFile());
        String ruleId = error.getId();
        if (!pathInTeamscale.isPresent()) {
            return;
        }
        if (!this.messageManager.hasRule(ruleId)) {
            LOGGER.warn("Unknown rule with id '" + ruleId + "' in uploaded Cppcheck report.");
            return;
        }
        this.addFindingForPath(pathInTeamscale.get(), this.createFinding(ruleId, error.getMessage(), pathInTeamscale.get(), primaryLocation, error.getSecondaryLocations()));
    }

    public DetachedFinding createFinding(String ruleId, String message, String pathInTeamscale, CppcheckLocation primaryLocation, List<CppcheckLocation> secondaryLocations) throws StorageException {
        DetachedFinding finding = CppcheckReportParser.createFindingWithLocation(ruleId, this.messageManager.getFindingsGroupNameFor(ruleId), this.messageManager.getFindingCategoryName(), message, (ElementLocation)CppcheckReportParser.createLineLocation(pathInTeamscale, primaryLocation.getLine()));
        for (CppcheckLocation secondaryLocation : secondaryLocations) {
            Optional<String> secondaryFileInTeamscale = this.resolvePath(secondaryLocation.getFile());
            if (!secondaryFileInTeamscale.isPresent()) continue;
            finding.addSecondaryLocation((ElementLocation)CppcheckReportParser.createLineLocation(secondaryFileInTeamscale.get(), secondaryLocation.getLine()));
        }
        return finding;
    }
}

