/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.findbugs;

import com.teamscale.index.report.findbugs.EBugCollectionAttributes;
import com.teamscale.index.report.findbugs.EBugCollectionElements;
import com.teamscale.index.report.findbugs.FindbugsMessageManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.XMLReaderBase;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;

public abstract class FindBugsReportConsumerBase
extends XMLReaderBase<EBugCollectionElements, EBugCollectionAttributes, ConQATException> {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean findingCreated = false;

    protected FindBugsReportConsumerBase(String reportContent) {
        super(reportContent, EBugCollectionAttributes.class);
    }

    public void load() throws ConQATException {
        this.parseAndWrapExceptions();
        this.processChildElements(new BugInstanceProcessor());
    }

    private void createFinding(String findbugsRule, String message, String sourcePath) throws ConQATException {
        this.processChildElements(new SourceLineProcessor(findbugsRule, message));
        if (!this.findingCreated) {
            this.processChildElements(new MethodAndFieldProcessor(EBugCollectionElements.Field, null, null, findbugsRule, message));
        }
        if (!this.findingCreated) {
            this.processChildElements(new MethodAndFieldProcessor(EBugCollectionElements.Method, null, null, findbugsRule, message));
        }
        if (!this.findingCreated) {
            this.processChildElements(new ClassProcessor(findbugsRule, message));
        }
        if (!this.findingCreated) {
            LOGGER.warn("No specific locations found for '" + sourcePath + "'. Adding plain file location.");
            this.createFileFinding(findbugsRule, message, sourcePath);
        }
    }

    protected abstract void createFileFinding(String var1, String var2, String var3) throws ConQATException;

    protected abstract boolean createRegionFinding(String var1, String var2, String var3, Integer var4, Integer var5) throws ConQATException;

    private final class BugInstanceProcessor
    implements IXMLElementProcessor<EBugCollectionElements, ConQATException> {
        private BugInstanceProcessor() {
        }

        public EBugCollectionElements getTargetElement() {
            return EBugCollectionElements.BugInstance;
        }

        public void process() throws ConQATException {
            String type = FindBugsReportConsumerBase.this.getStringAttribute(EBugCollectionAttributes.type);
            HashSet<String> classNames = new HashSet<String>();
            ArrayList<String> methodAndFieldNames = new ArrayList<String>();
            ClassProcessor cp = new ClassProcessor(null, null);
            this.extractLocationInformation(cp, classNames, methodAndFieldNames);
            FindBugsReportConsumerBase.this.findingCreated = false;
            FindBugsReportConsumerBase.this.createFinding(type, FindbugsMessageManager.getInstance().getShortDescription(type), cp.sourcePath);
            if (!FindBugsReportConsumerBase.this.findingCreated) {
                LOGGER.warn("Could not create finding as no locations were found (see messages above)");
            }
        }

        private void extractLocationInformation(ClassProcessor cp, Set<String> classNames, List<String> methodAndFieldNames) throws ConQATException {
            FindBugsReportConsumerBase.this.processChildElements(cp);
            classNames.add(cp.className);
            FindBugsReportConsumerBase.this.processChildElements(new MethodAndFieldProcessor(EBugCollectionElements.Method, classNames, methodAndFieldNames, null, null));
            FindBugsReportConsumerBase.this.processChildElements(new MethodAndFieldProcessor(EBugCollectionElements.Field, classNames, methodAndFieldNames, null, null));
        }
    }

    private final class SourceLineProcessor
    implements IXMLElementProcessor<EBugCollectionElements, ConQATException> {
        private String sourcePath;
        private final String findbugsRule;
        private final String message;

        public SourceLineProcessor(String findbugsRule, String message) {
            this.findbugsRule = findbugsRule;
            this.message = message;
        }

        public EBugCollectionElements getTargetElement() {
            return EBugCollectionElements.SourceLine;
        }

        public void process() throws ConQATException {
            this.sourcePath = FindBugsReportConsumerBase.this.getStringAttribute(EBugCollectionAttributes.sourcepath);
            if (this.findbugsRule == null || FindBugsReportConsumerBase.this.findingCreated) {
                return;
            }
            Integer startLine = this.obtainLineNumber(EBugCollectionAttributes.start);
            Integer endLine = this.obtainLineNumber(EBugCollectionAttributes.end);
            if (startLine != null && endLine != null) {
                endLine = Math.max(startLine, endLine);
                FindBugsReportConsumerBase.this.findingCreated = FindBugsReportConsumerBase.this.createRegionFinding(this.sourcePath, this.findbugsRule, this.message, startLine, endLine);
            }
        }

        private Integer obtainLineNumber(EBugCollectionAttributes attribute) {
            String lineAsString = FindBugsReportConsumerBase.this.getStringAttribute(attribute);
            if (StringUtils.isEmpty((String)lineAsString)) {
                return null;
            }
            try {
                return Integer.parseInt(lineAsString);
            }
            catch (NumberFormatException ex) {
                LOGGER.warn("Invalid line number information for " + this.sourcePath + ": '" + lineAsString + "'");
                return null;
            }
        }
    }

    private final class MethodAndFieldProcessor
    implements IXMLElementProcessor<EBugCollectionElements, ConQATException> {
        private final EBugCollectionElements targetElement;
        private final Set<String> classNames;
        private final List<String> methodAndFieldNames;
        private final String findbugsRule;
        private final String message;

        public MethodAndFieldProcessor(EBugCollectionElements targetElement, Set<String> classNames, List<String> methodAndFieldNames, String findbugsRule, String message) {
            this.targetElement = targetElement;
            this.classNames = classNames;
            this.methodAndFieldNames = methodAndFieldNames;
            this.findbugsRule = findbugsRule;
            this.message = message;
        }

        public EBugCollectionElements getTargetElement() {
            return this.targetElement;
        }

        public void process() throws ConQATException {
            if (this.classNames != null) {
                this.classNames.add(FindBugsReportConsumerBase.this.getStringAttribute(EBugCollectionAttributes.classname));
            }
            if (StringUtils.isEmpty((String)FindBugsReportConsumerBase.this.getStringAttribute(EBugCollectionAttributes.role))) {
                if (this.methodAndFieldNames != null) {
                    this.methodAndFieldNames.add(FindBugsReportConsumerBase.this.getStringAttribute(EBugCollectionAttributes.name));
                }
                if (this.findbugsRule != null) {
                    FindBugsReportConsumerBase.this.processChildElements(new SourceLineProcessor(this.findbugsRule, this.message));
                }
            }
        }
    }

    private final class ClassProcessor
    implements IXMLElementProcessor<EBugCollectionElements, ConQATException> {
        private String className;
        private String sourcePath;
        private final String findbugsRule;
        private final String message;

        public ClassProcessor(String findbugsRule, String message) {
            this.findbugsRule = findbugsRule;
            this.message = message;
        }

        public EBugCollectionElements getTargetElement() {
            return EBugCollectionElements.Class;
        }

        public void process() throws ConQATException {
            if (StringUtils.isEmpty((String)FindBugsReportConsumerBase.this.getStringAttribute(EBugCollectionAttributes.role))) {
                this.className = FindBugsReportConsumerBase.this.getStringAttribute(EBugCollectionAttributes.classname);
                SourceLineProcessor slp = new SourceLineProcessor(this.findbugsRule, this.message);
                FindBugsReportConsumerBase.this.processChildElements(slp);
                if (this.sourcePath == null) {
                    this.sourcePath = slp.sourcePath;
                }
            }
        }
    }
}

