/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

public abstract class CommitGraphNode
implements Comparable<CommitGraphNode> {
    private static final Logger LOGGER = LogManager.getLogger();
    @JsonProperty(value="branchName")
    protected String branchName;
    @JsonIgnore
    protected List<CommitGraphNode> parents = new ArrayList<CommitGraphNode>();
    @JsonIgnore
    protected List<CommitGraphNode> successors = new ArrayList<CommitGraphNode>();
    @JsonProperty(value="name")
    private final String name;

    protected CommitGraphNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract long getCommitTimestamp();

    public abstract String getCommitMessage();

    public abstract RevCommit getCommit();

    public abstract AnyObjectId getCommitId();

    public abstract void resolve(Map<String, CommitGraphNode> var1);

    public String getBranchName() {
        return this.branchName;
    }

    public boolean hasBranchNameSet() {
        return !StringUtils.isEmpty((String)this.branchName);
    }

    private boolean hasBranchNameSetToOtherThan(String allowedBranchName) {
        return this.hasBranchNameSet() && !this.branchName.equals(allowedBranchName);
    }

    public boolean isBranchNameUnsetOrEqualTo(String allowedBranchName) {
        return !this.hasBranchNameSet() || this.branchName.equals(allowedBranchName);
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    @Override
    public int compareTo(CommitGraphNode other) {
        return this.getName().compareTo(other.getName());
    }

    public CommitGraphNode getFirstParent() {
        if (this.parents.isEmpty()) {
            return null;
        }
        return this.parents.get(0);
    }

    public UnmodifiableList<CommitGraphNode> getParents() {
        return CollectionUtils.asUnmodifiable(this.parents);
    }

    public List<CommitGraphNode> getSuccessors() {
        return CollectionUtils.asUnmodifiable(this.successors);
    }

    public boolean isRoot() {
        return this.parents.isEmpty();
    }

    public boolean isHead() {
        if (!this.hasBranchNameSet()) {
            return this.successors.isEmpty();
        }
        return this.successors.stream().allMatch(successor -> successor.hasBranchNameSetToOtherThan(this.branchName));
    }

    public boolean isMerge() {
        return this.parents.size() > 1;
    }

    public boolean isFork() {
        return this.parents.size() == 1 && !Objects.equals(this.parents.get(0).getBranchName(), this.branchName);
    }

    public void remove() {
        for (CommitGraphNode parent : this.parents) {
            parent.successors.remove(this);
        }
        this.parents.clear();
        for (CommitGraphNode successor : this.successors) {
            successor.parents.remove(this);
        }
        this.successors.clear();
    }

    public static List<CommitGraphNode> topSort(Collection<CommitGraphNode> allNodes) {
        ArrayList<CommitGraphNode> result = new ArrayList<CommitGraphNode>();
        IdentityHashMap<CommitGraphNode, Integer> parentCounts = new IdentityHashMap<CommitGraphNode, Integer>();
        PriorityQueue<CommitGraphNode> toBeProcessed = new PriorityQueue<CommitGraphNode>(Comparator.comparing(CommitGraphNode::getCommitTimestamp).thenComparing(CommitGraphNode::getName));
        for (CommitGraphNode node : allNodes) {
            int parentCount = node.parents.size();
            parentCounts.put(node, parentCount);
            if (parentCount != 0) continue;
            toBeProcessed.add(node);
        }
        while (!toBeProcessed.isEmpty()) {
            CommitGraphNode next = (CommitGraphNode)toBeProcessed.poll();
            result.add(next);
            for (CommitGraphNode successor : next.successors) {
                if (!parentCounts.containsKey(successor)) {
                    CCSMAssert.fail((String)("Could not resolve reference to node: " + String.valueOf(successor)));
                }
                int parentCount = (Integer)parentCounts.get(successor) - 1;
                parentCounts.put(successor, parentCount);
                if (parentCount != 0) continue;
                toBeProcessed.add(successor);
            }
        }
        if (result.size() != allNodes.size()) {
            CommitGraphNode.logTopSortDebugInfoAndThrowAssertionError(result, allNodes);
        }
        return result;
    }

    private static void logTopSortDebugInfoAndThrowAssertionError(List<CommitGraphNode> result, Collection<CommitGraphNode> allNodes) throws AssertionError {
        HashSet difference = CollectionUtils.differenceSet(allNodes, (Collection[])new Collection[]{result});
        LOGGER.error("Nodes that could not be sorted: " + String.valueOf(difference));
        LOGGER.error("All Nodes: " + String.valueOf(allNodes));
        LOGGER.error("Sorted result subset: " + String.valueOf(result));
        CCSMAssert.fail((String)"Not all nodes could be top-sorted, which means that the input graph contained cycles!");
    }

    public void addSuccessor(CommitGraphNode successor) {
        this.successors.add(successor);
    }

    public ZonedDateTime getAuthorTime() {
        PersonIdent authorIdent = this.getCommit().getAuthorIdent();
        return ZonedDateTime.ofInstant(authorIdent.getWhen().toInstant(), authorIdent.getTimeZone().toZoneId());
    }

    public void addAsFirstParent(CommitGraphNode node) {
        CCSMAssert.isFalse((boolean)this.parents.contains(node), (String)"New parent may not already be included in parents list.");
        this.parents.add(0, node);
        node.addSuccessor(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommitGraphNode) {
            CommitGraphNode other = (CommitGraphNode)obj;
            return Objects.equals(this.branchName, other.branchName) && Objects.equals(this.getName(), other.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.branchName, this.getName());
    }

    public String toString() {
        return "CommitGraphNode [name=" + this.name + ", branchName=" + this.branchName + ", parents=" + CommitGraphNode.getNames(this.parents) + ", successors=" + CommitGraphNode.getNames(this.successors) + "]";
    }

    private static String getNames(Collection<CommitGraphNode> nodes) {
        return nodes.stream().map(CommitGraphNode::getName).collect(Collectors.joining(", "));
    }
}

