/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.git.GitRepositoryBase;
import com.teamscale.index.repository.git.GitSubModuleCommitReference;
import com.teamscale.index.repository.git.GitSubModuleRepository;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.ISubModuleRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class RecursiveSubModuleRegistry
implements ISubModuleRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CONFIG_URL_KEY = "url";
    private static final String CONFIG_PATH_KEY = "path";
    private static final String GIT_MODULES_PATH = ".gitmodules";
    private final GitRepositoryBase parentRepository;
    private final Map<String, GitSubModuleRepository> subModules = new HashMap<String, GitSubModuleRepository>();
    private final boolean convertSshToHttpsUrl;

    public RecursiveSubModuleRegistry(GitRepositoryBase parentRepository, boolean convertSshToHttpsUrl) {
        this.parentRepository = parentRepository;
        this.convertSshToHttpsUrl = convertSshToHttpsUrl;
    }

    @Override
    public Set<String> crawl(RevCommit commit, String basePath, int recursionDepth) throws RepositoryException {
        if (recursionDepth <= 0) {
            return CollectionUtils.emptySet();
        }
        HashSet<String> paths = new HashSet<String>();
        for (Map.Entry<String, GitSubModuleCommitReference> entry : this.listSubModules(commit).entrySet()) {
            GitSubModuleCommitReference subModuleCommit = entry.getValue();
            paths.addAll(subModuleCommit.getSubModule().crawl(subModuleCommit.getCommit(), this.getSubModulePath(basePath, entry.getKey()), recursionDepth - 1));
        }
        return paths;
    }

    @Override
    public Optional<byte[]> getContent(String path, RevCommit commit, int recursionDepth) throws RepositoryException {
        if (recursionDepth <= 0) {
            return Optional.empty();
        }
        for (Map.Entry<String, GitSubModuleCommitReference> entry : this.listSubModules(commit).entrySet()) {
            String subModulePath = entry.getKey() + "/";
            GitSubModuleCommitReference subModuleCommit = entry.getValue();
            if (!path.startsWith(subModulePath)) continue;
            String pathInSubModule = StringUtils.stripPrefix((String)path, (String)subModulePath);
            return subModuleCommit.getSubModule().getContent(pathInSubModule, subModuleCommit.getRevision(), recursionDepth - 1);
        }
        return Optional.empty();
    }

    @Override
    public void createChangeEntries(RevCommit commit, RevCommit parentCommit, RepositoryChangeSet changeSet, String branchName, String basePath, int recursionDepth) throws RepositoryException {
        if (recursionDepth <= 0) {
            return;
        }
        Map<String, Pair<GitSubModuleCommitReference, GitSubModuleCommitReference>> subModuleCommits = this.listSubModuleCommits(commit, parentCommit);
        for (Map.Entry<String, Pair<GitSubModuleCommitReference, GitSubModuleCommitReference>> entry : subModuleCommits.entrySet()) {
            RecursiveSubModuleRegistry.computeChangeEntries((GitSubModuleCommitReference)entry.getValue().getFirst(), (GitSubModuleCommitReference)entry.getValue().getSecond(), changeSet, branchName, this.getSubModulePath(basePath, entry.getKey()), recursionDepth);
        }
    }

    private static void computeChangeEntries(GitSubModuleCommitReference commit, GitSubModuleCommitReference parentCommit, RepositoryChangeSet changeSet, String branchName, String basePath, int recursionDepth) throws RepositoryException {
        if (parentCommit == null) {
            RecursiveSubModuleRegistry.computeSubModuleAddOrDeleteChanges(commit, changeSet, basePath, recursionDepth, ERepositoryChangeType.ADD);
        } else if (commit == null) {
            RecursiveSubModuleRegistry.computeSubModuleAddOrDeleteChanges(parentCommit, changeSet, basePath, recursionDepth, ERepositoryChangeType.DELETE);
        } else {
            commit.getSubModule().createChangeEntries(commit.getCommit(), parentCommit.getCommit(), changeSet, branchName, basePath, recursionDepth - 1);
        }
    }

    private static void computeSubModuleAddOrDeleteChanges(GitSubModuleCommitReference commit, RepositoryChangeSet changeSet, String basePath, int recursionDepth, ERepositoryChangeType changeType) throws RepositoryException {
        GitSubModuleRepository subModule = commit.getSubModule();
        for (String path : subModule.crawl(commit.getCommit(), basePath, recursionDepth - 1)) {
            changeSet.addChange(path, changeType);
        }
    }

    public Map<String, Pair<GitSubModuleCommitReference, GitSubModuleCommitReference>> listSubModuleCommits(RevCommit commit, RevCommit parentCommit) throws RepositoryException {
        String path;
        HashMap<String, Pair<GitSubModuleCommitReference, GitSubModuleCommitReference>> commits = new HashMap<String, Pair<GitSubModuleCommitReference, GitSubModuleCommitReference>>();
        Map<String, GitSubModuleCommitReference> subModules = this.listSubModules(commit);
        Map<String, GitSubModuleCommitReference> parentSubModules = this.listSubModules(parentCommit);
        for (Map.Entry<String, GitSubModuleCommitReference> entry : subModules.entrySet()) {
            path = entry.getKey();
            GitSubModuleCommitReference subModuleCommit = entry.getValue();
            GitSubModuleCommitReference parentSubModuleCommit = parentSubModules.get(path);
            if (parentSubModuleCommit != null && !subModuleCommit.getSubModule().equals(parentSubModuleCommit.getSubModule())) {
                LOGGER.warn("Computing a diff between two different sub-modules at the same path is not supported. The corresponding commits are " + subModuleCommit.getRevision() + " and " + parentSubModuleCommit.getRevision() + " at path '" + path + "'.");
                continue;
            }
            commits.put(path, (Pair<GitSubModuleCommitReference, GitSubModuleCommitReference>)new Pair((Object)subModuleCommit, (Object)parentSubModuleCommit));
        }
        for (Map.Entry<String, GitSubModuleCommitReference> entry : parentSubModules.entrySet()) {
            path = entry.getKey();
            if (subModules.containsKey(path)) continue;
            commits.put(path, (Pair<GitSubModuleCommitReference, GitSubModuleCommitReference>)new Pair(null, (Object)entry.getValue()));
        }
        return commits;
    }

    @Override
    public void initAndSynchronizeSubModules(Collection<String> revisions, int recursionDepth) throws RepositoryException {
        if (recursionDepth <= 0) {
            return;
        }
        ListMap subModulesWithCommit = new ListMap();
        for (String revision : revisions) {
            Optional<RevCommit> commit = this.parentRepository.getOptionalCommit(revision);
            if (commit.isPresent()) {
                Collection<GitSubModuleCommitReference> subModuleCommits = this.listSubModules(commit.get()).values();
                for (GitSubModuleCommitReference subModuleCommit : subModuleCommits) {
                    subModulesWithCommit.add((Object)subModuleCommit.getSubModule(), (Object)subModuleCommit.getRevision());
                }
                continue;
            }
            RecursiveSubModuleRegistry.logNonExistentCommitWarning(revision, this.parentRepository);
        }
        for (GitSubModuleRepository subModule : subModulesWithCommit.getKeys()) {
            subModule.initAndSynchronizeSubModules(subModulesWithCommit.getCollection((Object)subModule), recursionDepth - 1);
        }
    }

    private static void logNonExistentCommitWarning(String revision, GitRepositoryBase repository) {
        LOGGER.warn("Referenced commit " + revision + " does not exist in submodule " + String.valueOf(repository.getLocation()) + ".");
    }

    private Map<String, GitSubModuleCommitReference> listSubModules(RevCommit commit) throws RepositoryException {
        Optional<Config> config = this.readSubModuleConfig(commit);
        if (!config.isPresent()) {
            return CollectionUtils.emptyMap();
        }
        return this.listSubModulesFromConfig(commit, config.get());
    }

    private Optional<Config> readSubModuleConfig(RevCommit commit) throws RepositoryException {
        Optional<String> gitModuleContent = this.parentRepository.getTextContent(commit, GIT_MODULES_PATH);
        if (!gitModuleContent.isPresent()) {
            return Optional.empty();
        }
        Config config = new Config();
        try {
            config.fromText(gitModuleContent.get());
        }
        catch (ConfigInvalidException e) {
            LOGGER.warn("Submodule configuration could not be read.");
            return Optional.empty();
        }
        return Optional.of(config);
    }

    private Map<String, GitSubModuleCommitReference> listSubModulesFromConfig(RevCommit commit, Config config) throws RepositoryException {
        HashMap<String, GitSubModuleCommitReference> subModulesForRevision = new HashMap<String, GitSubModuleCommitReference>();
        for (String section : config.getSections()) {
            for (String subSection : config.getSubsections(section)) {
                String path = config.getString(section, subSection, CONFIG_PATH_KEY);
                String url = config.getString(section, subSection, CONFIG_URL_KEY);
                url = GitUtils.rewriteGitAtUrl(url, this.convertSshToHttpsUrl);
                Optional<ObjectId> id = this.parentRepository.getId(commit, path);
                if (!id.isPresent()) continue;
                this.createSubModuleCommitForRevision(subModulesForRevision, path, url, id.get().getName());
            }
        }
        return subModulesForRevision;
    }

    public void createSubModuleCommitForRevision(Map<String, GitSubModuleCommitReference> subModulesForRevision, String path, String url, String revision) {
        Optional<GitSubModuleRepository> subModule = this.getCachedSubModule(url, () -> "Path: " + path + ", Revision: " + revision);
        if (subModule.isPresent()) {
            GitSubModuleCommitReference commitReference = new GitSubModuleCommitReference(subModule.get(), revision);
            if (commitReference.commitExists()) {
                subModulesForRevision.put(path, commitReference);
            } else {
                RecursiveSubModuleRegistry.logNonExistentCommitWarning(revision, commitReference.getSubModule());
            }
        }
    }

    private Optional<GitSubModuleRepository> getCachedSubModule(String url, Supplier<String> messageContextSupplier) {
        if (this.subModules.containsKey(url)) {
            return Optional.ofNullable(this.subModules.get(url));
        }
        Optional<GitSubModuleRepository> newSubModule = this.parentRepository.createSubModule(url, messageContextSupplier);
        this.subModules.put(url, newSubModule.orElse(null));
        return newSubModule;
    }

    public String getSubModulePath(String basePath, String subModulePath) {
        return basePath + subModulePath + "/";
    }
}

