/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.autogc;

import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.GitWriteLockManager;
import com.teamscale.index.repository.git.autogc.GitAutoGCOption;
import com.teamscale.index.repository.git.autogc.PendingGarbageCollectionIndex;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.ProcessUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.GC;
import org.eclipse.jgit.lib.Repository;

public class GitGarbageCollectionMaintenanceTrigger
extends OptionScheduledTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration GARBAGE_COLLECTION_FILE_EXPIRATION = Duration.ofDays(1L);

    public void execute() throws Exception {
        if (!GitAutoGCOption.isEnabled(this.indexLayer.openGlobalStorageSystem())) {
            LOGGER.info("Skipping Git auto GC because the server option is disabled.");
            return;
        }
        PendingGarbageCollectionIndex pendingGarbageCollections = (PendingGarbageCollectionIndex)this.indexLayer.openGlobalIndex(PendingGarbageCollectionIndex.class);
        for (String repositoryPath : pendingGarbageCollections.popPendingGCs()) {
            if (this.isCanceled()) {
                pendingGarbageCollections.requestGC(repositoryPath);
                continue;
            }
            try {
                Git git = Git.open((File)new File(repositoryPath));
                try {
                    this.runGC(git.getRepository());
                }
                finally {
                    if (git == null) continue;
                    git.close();
                }
            }
            catch (RepositoryNotFoundException e) {
                LOGGER.warn("Cancelling garbage collection because repository was not found at \"{}\". It may have been deleted in the meantime.", (Object)repositoryPath, (Object)e);
            }
            catch (Exception e) {
                pendingGarbageCollections.requestGC(repositoryPath);
            }
        }
    }

    private void runGC(Repository repository) throws IOException, ParseException, RepositoryException {
        try (GitWriteLockManager.GitDirectoryLock ignored = GitWriteLockManager.lockGitRepositoryForWriting(repository);){
            LOGGER.info("Running Git garbage collector on '{}'.", (Object)repository.getDirectory());
            ProcessUtils.ExecutionResult result = GitUtils.runNativeGitCommand(repository, Duration.ofMinutes(10L), "gc", new String[0]);
            if (GitGarbageCollectionMaintenanceTrigger.terminatedBecauseGCAlreadyRunning(result)) {
                LOGGER.debug("Skipping running native git gc for '{}', because gc is already running (process exit code: {})\n\nError output:\n{}", (Object)repository.getDirectory(), (Object)result.getReturnCode(), (Object)result.getStderr());
                return;
            }
            if (result.terminatedByTimeoutOrInterruption() || result.getReturnCode() != 0) {
                this.runJGitGC(repository);
            }
        }
        catch (IOException e) {
            this.runJGitGC(repository);
        }
    }

    private void runJGitGC(Repository repository) throws IOException, ParseException {
        LOGGER.warn("Problem executing native GC, falling back to JGit GC. Might be much slower.");
        GC gc = new GC((FileRepository)CCSMAssert.checkedCast((Object)repository, FileRepository.class));
        Date expirationDate = Date.from(Instant.now().minus(GARBAGE_COLLECTION_FILE_EXPIRATION));
        gc.setPackExpire(expirationDate);
        gc.setExpire(expirationDate);
        gc.setProgressMonitor(GitUtils.createShutdownAndCancelAwareProgressMonitor((ICancelable)this));
        gc.gc();
    }

    private static boolean terminatedBecauseGCAlreadyRunning(ProcessUtils.ExecutionResult result) {
        return result.getReturnCode() == 128 && result.getStderr().contains("gc is already running");
    }

    public ETriggerCost getExpectedCost() {
        return ETriggerCost.EXPENSIVE;
    }
}

