/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.pullrequest.BitbucketCloudPullRequestEndpoint;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class BitbucketCloudPullRequest {
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="source")
    private BitbucketCloudPullRequestEndpoint source;
    @JsonProperty(value="destination")
    private BitbucketCloudPullRequestEndpoint destination;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="description")
    private @Nullable String description;
    @JsonProperty(value="created_on")
    private String createdOn;
    @JsonProperty(value="updated_on")
    private String updatedOn;

    public long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public BitbucketCloudPullRequestStates getState() {
        return BitbucketCloudPullRequestStates.valueOf(this.state);
    }

    @JsonCreator
    BitbucketCloudPullRequest() {
    }

    public String getDestinationBranchName() {
        return this.destination.getBranch().getName();
    }

    public String getSourceCommitHash() {
        return this.source.getCommit().getHash();
    }

    public String getSourceBranchName() {
        return this.source.getBranch().getName();
    }

    public String getSourceRepoUuid() {
        return this.source.getRepository().getUuid();
    }

    public String getDescription() {
        return Objects.requireNonNullElse(this.description, "");
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public BitbucketCloudPullRequestEndpoint getSource() {
        return this.source;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public String getUpdatedOn() {
        return this.updatedOn;
    }

    public static enum BitbucketCloudPullRequestStates {
        OPEN,
        MERGED,
        DECLINED,
        SUPERSEDED;

    }
}

