/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.rest.client.authentication.ERestClientAuthenticationMode;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.git.GitBranchRetriever;
import com.teamscale.index.repository.git.GitIndices;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.autogc.PendingGarbageCollectionIndex;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import com.teamscale.index.repository.git.gerrit.GerritRepositoryConnection;
import com.teamscale.index.repository.git.gerrit.GerritRepositoryConnectorDescriptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.TreeSet;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.resource.util.UniformPathUtils;

public class GerritBranchRetriever
extends GitBranchRetriever {
    public GerritBranchRetriever(ServerOptionIndex serverOptionIndex, String repositoryDescriptor) {
        super(serverOptionIndex, repositoryDescriptor);
    }

    private TreeSet<String> getGitBranches(ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException, ProjectConfigurationException {
        String projectName = GerritRepositoryConnectorDescriptor.getGerritProjectName(connectorConfiguration);
        URI gitServerUri = GitRepositoryConnector.adjustGitUrlAndConvertToUri(credentials.uri, UniformPathUtils.concatenate((String[])new String[]{"a", projectName}));
        return new TreeSet<String>(super.fetchBranchesAtUri(credentials, connectorConfiguration, gitServerUri));
    }

    @Override
    public Set<String> fetchBranches(boolean projectExists, String username, ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException, ProjectConfigurationException {
        TreeSet<String> treeSet;
        TreeSet<String> allBranches = this.getGitBranches(credentials, connectorConfiguration);
        String connectionIdentifier = connectorConfiguration.getIdentifier();
        String defaultBranchName = connectorConfiguration.getOptionValue("Default branch name");
        RepositoryConnectorBaseParameterStep baseParameters = RepositoryConnectorBaseParameterStep.builder(connectionIdentifier, defaultBranchName).withBranchingEnabled(true).build();
        GitRepositoryConnectorParameterStep gitParameters = GitRepositoryConnectorParameterStep.builder(GerritBranchRetriever.createIndices(this.serverOptionIndex), (IBranchingLayer)new CommitLayeringBranchingLayer((IStore)new InMemoryStore(), (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout())).build();
        GerritRepositoryConnection connection = new GerritRepositoryConnection(baseParameters, gitParameters, GitRepositoryConnector.adjustGitUrlAndConvertToUri(credentials.uri), credentials.username, credentials.password, GerritRepositoryConnectorDescriptor.getGerritProjectName(connectorConfiguration), null, null, ERestClientAuthenticationMode.BASIC, 360, null, false, ICancelable.neverCanceled());
        try {
            connection.doSynchronize();
            allBranches.addAll(connection.getVirtualBranches());
            treeSet = allBranches;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (URISyntaxException e) {
                throw new ProjectConfigurationException("Invalid Repository URI: " + e.getMessage(), (Throwable)e);
            }
        }
        connection.close();
        return treeSet;
    }

    private static GitIndices createIndices(ServerOptionIndex serverOptionIndex) {
        return new GitIndices(new GitRepositoryInfoIndex((IStore)new InMemoryStore()), serverOptionIndex, new AccessTokenIndex((IStore)new InMemoryStore()), new PostponedRollbackIndex((IStore)new InMemoryStore()), new RepositoryRevisionIndex(), new PendingGarbageCollectionIndex((IStore)new InMemoryStore()), new CrossRepositoryMergeRequestSourceBranchesIndex((IStore)new InMemoryStore()));
    }
}

