/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.GitHubAppUtils;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.client.GitHubAppClient;
import com.teamscale.core.authenticate.github.dto.InstallationRepository;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndexSynchronizer;
import com.teamscale.core.authenticate.github.index.LongKey;
import com.teamscale.core.authenticate.github.index.OrgOrUserInstallationsKey;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.client.GitHubRepositoriesClient;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.SupplierWithTwoExceptions;
import org.jspecify.annotations.Nullable;

public class GitHubAppBasedRepositoryAccessHelper<X extends Exception> {
    private final String gitHubServerUrl;
    private final String repositoryName;
    private final GitHubInstallationIndex installationIndex;
    private final ServerOptionIndex serverOptionIndex;
    private final AccessTokenIndex accessTokenIndex;
    private final Function<String, X> exceptionFactory;
    private final MemoizingSupplierWithExceptions<Long> installationId;
    private final MemoizingSupplierWithExceptions<GitHubApplicationDescription> applicationDescription;
    private final MemoizingSupplierWithExceptions<GitHubAppClient> gitHubAppClient;
    private final Logger logger;

    public GitHubAppBasedRepositoryAccessHelper(String gitHubServerUrl, String repositoryName, GlobalStorageSystem globalStorageSystem, Function<String, X> exceptionFactory, Logger logger) throws StorageException {
        this(gitHubServerUrl, repositoryName, (GitHubInstallationIndex)globalStorageSystem.openGlobalIndex(GitHubInstallationIndex.class), (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class), (AccessTokenIndex)globalStorageSystem.openGlobalIndex(AccessTokenIndex.class), exceptionFactory, logger);
    }

    public GitHubAppBasedRepositoryAccessHelper(String gitHubServerUrl, String repositoryName, GitHubInstallationIndex installationIndex, ServerOptionIndex serverOptionIndex, AccessTokenIndex accessTokenIndex, Function<String, X> exceptionFactory, Logger logger) {
        this.gitHubServerUrl = gitHubServerUrl;
        this.repositoryName = repositoryName;
        this.installationIndex = installationIndex;
        this.serverOptionIndex = serverOptionIndex;
        this.accessTokenIndex = accessTokenIndex;
        this.exceptionFactory = exceptionFactory;
        this.logger = logger;
        this.installationId = new MemoizingSupplierWithExceptions(this, this::findInstallationForRepository);
        this.applicationDescription = new MemoizingSupplierWithExceptions(this, this::retrieveApplicationDescription);
        this.gitHubAppClient = new MemoizingSupplierWithExceptions(this, () -> new GitHubAppClient(this.applicationDescription.get(), accessTokenIndex, logger));
    }

    public long getInstallationId() throws X, StorageException {
        return this.installationId.get();
    }

    public GitHubApplicationDescription getApplicationDescription() throws X, StorageException {
        return this.applicationDescription.get();
    }

    public GitHubAppClient getAppClient() throws X, StorageException {
        return this.gitHubAppClient.get();
    }

    public String getInstallationAccessToken() throws X, ServiceCallException, StorageException {
        return this.gitHubAppClient.get().getOrCreateInstallationToken(this.installationId.get().longValue());
    }

    public GitHubPullRequestClient createGitHubPullRequestClient() throws X, StorageException, ServiceCallException {
        return new GitHubPullRequestClient(this.applicationDescription.get(), this.getInstallationAccessToken(), this.logger);
    }

    public GitHubRepositoriesClient createGitHubRepositoriesClient() throws X, StorageException, ServiceCallException {
        return new GitHubRepositoriesClient(this.applicationDescription.get(), this.getInstallationAccessToken(), this.logger);
    }

    public String getRepositoryCloneUrl() throws X, StorageException, ServiceCallException {
        return this.getRepositoryUrl(InstallationRepository::getCloneUrl);
    }

    public String getRepositoryHtmlUrl() throws X, StorageException, ServiceCallException {
        return this.getRepositoryUrl(InstallationRepository::getHtmlUrl);
    }

    private String getRepositoryUrl(Function<InstallationRepository, String> urlMapper) throws X, StorageException, ServiceCallException {
        InstallationRepository repository = (InstallationRepository)this.gitHubAppClient.get().getInstallationRepositories(this.installationId.get().longValue()).getRepositoryByFullName(this.repositoryName).orElseThrow(() -> (Exception)this.exceptionFactory.apply("Repository " + this.repositoryName + " not found. It either does not exist or the installation is not allowed to access the repository."));
        return urlMapper.apply(repository);
    }

    private long findInstallationForRepository() throws X, StorageException {
        Long installationId;
        String organizationOrUser = PlatformRepositoryIdentifier.fromRepositoryName(this.repositoryName, this.exceptionFactory).getOwner();
        OrgOrUserInstallationsKey orgOrUserInstallationsKey = new OrgOrUserInstallationsKey(this.gitHubServerUrl, organizationOrUser);
        Set installationsForOrganization = this.installationIndex.getInstallationsForOrganization(orgOrUserInstallationsKey);
        boolean performedFullSync = false;
        if (installationsForOrganization.isEmpty()) {
            GitHubInstallationIndexSynchronizer.performFullInstallationIndexSynchronisation((ServerOptionIndex)this.serverOptionIndex, (GitHubInstallationIndex)this.installationIndex, (AccessTokenIndex)this.accessTokenIndex, (Logger)this.logger);
            performedFullSync = true;
        }
        if ((installationId = this.findInstallationForRepository(orgOrUserInstallationsKey)) == null && !performedFullSync) {
            GitHubInstallationIndexSynchronizer.performFullInstallationIndexSynchronisation((ServerOptionIndex)this.serverOptionIndex, (GitHubInstallationIndex)this.installationIndex, (AccessTokenIndex)this.accessTokenIndex, (Logger)this.logger);
            installationId = this.findInstallationForRepository(orgOrUserInstallationsKey);
        }
        if (installationId != null) {
            return installationId;
        }
        throw (Exception)this.exceptionFactory.apply("No GitHub app installation for organization or user '%s' and GitHub URL '%s' with access to repository '%s' found. Maybe you need to install the GitHub App first.".formatted(organizationOrUser, this.gitHubServerUrl, this.repositoryName));
    }

    private @Nullable Long findInstallationForRepository(OrgOrUserInstallationsKey orgOrUserInstallationsKey) throws StorageException, X {
        Set installationsForOrganization = this.installationIndex.getInstallationsForOrganization(orgOrUserInstallationsKey);
        if (installationsForOrganization.isEmpty()) {
            throw (Exception)this.exceptionFactory.apply("No GitHub app installation found for organization or user '%s' and GitHub URL '%s'. Maybe you need to install the GitHub App first.".formatted(orgOrUserInstallationsKey.organizationOrUser(), orgOrUserInstallationsKey.gitHubServerUrl()));
        }
        Iterator iterator = installationsForOrganization.iterator();
        while (iterator.hasNext()) {
            long installationId = (Long)iterator.next();
            Set availableRepositories = this.installationIndex.getRepositoriesForInstallation(installationId);
            if (!availableRepositories.contains(this.repositoryName)) continue;
            return installationId;
        }
        return null;
    }

    private GitHubApplicationDescription retrieveApplicationDescription() throws X, StorageException {
        Long resolvedInstallationId = this.installationId.get();
        long appId = (Long)this.installationIndex.getAppId(new LongKey(resolvedInstallationId.longValue())).orElseThrow(() -> (Exception)this.exceptionFactory.apply("No configured App found on the provided GitHub instance: %s with access to repository '%s' and installation ID '%s'. Maybe you need to install the GitHub App first.".formatted(this.gitHubServerUrl, this.repositoryName, resolvedInstallationId)));
        return GitHubAppUtils.loadConfiguredApplication((String)Long.toString(appId), (String)this.gitHubServerUrl, (ServerOptionIndex)this.serverOptionIndex, this.exceptionFactory);
    }

    private class MemoizingSupplierWithExceptions<T>
    implements SupplierWithTwoExceptions<T, X, StorageException> {
        private T value;
        private SupplierWithTwoExceptions<T, X, StorageException> supplier;

        private MemoizingSupplierWithExceptions(GitHubAppBasedRepositoryAccessHelper gitHubAppBasedRepositoryAccessHelper, SupplierWithTwoExceptions<T, X, StorageException> supplier) {
            this.supplier = supplier;
        }

        public synchronized T get() throws Exception, StorageException {
            if (this.supplier != null) {
                this.value = this.supplier.get();
                this.supplier = null;
            }
            return this.value;
        }
    }
}

