/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import com.teamscale.index.repository.git.github.GitHubMergeRequestAnnotationTrigger;
import com.teamscale.index.repository.git.github.GitHubMergeRequestProvider;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.data.GitHubBuildJob;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class GitHubMergeRequestUpdateTrigger
extends MergeRequestUpdateTriggerBase<GitHubMergeRequestProvider, GitHubPullRequest, GitHubBuildJob> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    protected GitHubMergeRequestProvider createMergeRequestProvider(GlobalStorageSystem globalStorageSystem, ProjectStorageSystem projectStorageSystem, String repositoryName) throws StorageException, ServiceCallException {
        ConnectorConfiguration connector = GitHubMergeRequestUpdateTrigger.extractConnectorConfiguration(projectStorageSystem, repositoryName, ERepositoryConnector.GITHUB);
        String githubServerUrl = this.getJobExtraParameter();
        GitHubPullRequestClient client = new GitHubAppBasedRepositoryAccessHelper<ServiceCallException>(githubServerUrl, repositoryName, globalStorageSystem, ServiceCallException::new, LOGGER).createGitHubPullRequestClient();
        return new GitHubMergeRequestProvider(repositoryName, client, VotingConnectorUtils.getBuildIncludeExcludePatterns(connector), GitHubMergeRequestAnnotationTrigger.getContextIdentifier(connector));
    }

    @Override
    protected MergeRequestAnnotationTriggerBase<GitHubPullRequest, GitHubBuildJob> createMergeRequestAnnotationTrigger() {
        return new GitHubMergeRequestAnnotationTrigger();
    }
}

