/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.SapSystemConnection;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.RepositoryCloneOption;
import com.teamscale.index.repository.base.RepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.sap.abapsystem.AbapChangeRetriever;
import com.teamscale.index.repository.sap.abapsystem.AbapContentUpdater;
import eu.cqse.check.framework.scanner.ELanguage;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.index.shared.GitRefUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.jetbrains.annotations.TestOnly;

@ConnectorDescriptor
public class AbapRepositoryConnectorDescriptor
extends RepositoryConnectorDescriptorBase {
    public static final String SAP_CONNECTION_PARAMETER_NAME = "SAP connection";
    public static final String ABAP_CONTENT_EXCLUDE_PARAMETER_NAME = "Content exclude (ABAP)";
    public static final List<String> GENERATED_CODE_PATTERNS = new ArrayList<String>(List.of("(?i)(?m)^\\*\\*\\* Achtung !!! Diese Zeile bei manuellen .nderungen unbedingt l.schen !", "(?i)(?m)^\\*\\s+Dieser Baustein wurde generiert", "(?i)(?m)^\\*\\s+Dieses Include wird durch das Programm .*? erzeugt", "(?i)(?m)^\\*\\s+generation date: \\d\\d\\.\\d\\d\\.\\d\\d\\d\\d at \\d\\d:\\d\\d:\\d\\d", "(?i)(?m)^\\*\\s+regenerated at \\d\\d\\.\\d\\d\\.\\d\\d\\d\\d \\d\\d:\\d\\d:\\d\\d by", "(?i)(?m)^\\s*BEGIN_DATA OBJECT\\.\\s+\"\\s+Do not change\\.\\. DATA is generated", "(?i)(?m)^\\s*\\*\\$\\*\\$ Generated", "(?i)(?m)^\\s*\\*\\s+THIS IS A GENERATED FUNCTION MODULE. NEVER CHANGE IT MANUALLY", "(?i)(?m)^\\s*\\*\\s+THIS FILE IS GENERATED. NEVER CHANGE IT MANUALLY", "(?i)(?m)^\\s*\\*\\s+never change it manually. please!", "(?i)(?m)\\s*\\*&\\s+Generated code for the MODEL PROVIDER BASE CLASS", "(?i)(?m)\\s*\\*&\\*\\s+This class has been generated", "(?i)(?m)^\\s*interfaces /BOBF/IF_LIB_CONSTANTS ?\\.", "(?i)(?m)NEVER MODIFY THIS CLASS", "(?i)(?m)\\*===> Generated by program", "(?i)(?m)\\*===> Generiert durch Programm"));
    private static final String ABAP_TEXT_FILTER_PARAMETER_NAME = "Text filter (ABAP)";
    private static final String MODIFICATIONS_SYSTEM_IDS_REGEX_PARAMETER_NAME = "Modification system IDs";
    public static final String DEFAULT_BRANCH_NAME = "master";
    @ConfigExposed(name="SAP connection", description="The SAP connection used for exports to this repository.", required=true)
    private SapSystemConnection sapConnectionIdentifier;
    @ConfigExposed(name="Text filter (ABAP)", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="A list of regular expressions describing what parts of a file should be excluded from analysis, e.g. generated code. The syntax conforms to Java regular expressions. Multiple patterns can be separated by line break or comma. Code for AMDP (ABAP Managed Database Procedures) are excluded by default and must not be defined here.\nMake sure to escape reserved characters like '(', ')' or '.' as well as commas properly with the escape character '\\\\'. \nLines starting with '##' are ignored.", multilineText=true)
    protected final List<String> abapTextFilter = new ArrayList<String>();
    @ConfigExposed(name="Content exclude (ABAP)", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="A comma-separated list of filters that removes the complete content of an file (i.e., content is shown in grey and not analyzed) based on a regular expression matched against the file's content. The syntax conforms to Java regular expressions.The provided regex must match a substring of the file's content, i.e. 'generated' (without quotes) will exclude all files containing the substring 'generated'. The filters implicitly include some typical patterns for generated code in ABAP.\nMake sure to escape reserved characters like '(', ')' or '.' as well as commas properly with the escape character '\\\\'. \nLines starting with '##' are ignored.", multilineText=true)
    private final List<String> abapContentExclude = new ArrayList<String>();
    @ConfigExposed(name="Modification system IDs", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="A Java regular expression stating which modifications should be analyzed.\nThe empty default value analyzes all modifications.\nTeamscale Connector for SAP NetWeaver exports customer modifications of SAP objects.\nEach modification has an ID that includes the system ID (three characters) on which it was initially created.\n\nIn this configuration option, you can configure for which system IDs modifications should be analyzed.\nThe option is a Java regular expression, so you can also analyze the modifications originating from multiple systems.\nFor example the option value `A[A-Z]X` would analyze modifications from all systems starting with `A` and ending with `X`.\n\nMake sure to escape reserved characters like '(', ')' or '.' as well as commas properly with the escape character '\\\\'. ", multilineText=false)
    private String modificationsSystemIdsRegex = "";

    public AbapRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.ABAP_GIT, DEFAULT_BRANCH_NAME);
        this.autoExpose();
        this.hideOption("Default branch name");
        this.hideOption("Included branches");
        this.hideOption("Excluded branches");
        this.hideOption("Enable branch analysis");
        this.hideOption("Polling interval");
        this.hideOption("Language mapping");
        this.hideOption("Source library connector");
        this.hideOption("Encoding");
        this.hideOption("Branch transformation");
        this.hideOption("Text filter");
        this.hideOption("Content exclude");
        this.overwritePollingIntervalDefaultValue();
    }

    private void overwritePollingIntervalDefaultValue() {
        int pollingIntervalForAbapConnector;
        this.pollingIntervalSeconds = pollingIntervalForAbapConnector = Integer.getInteger("com.teamscale.abap_connector.debug.polling_interval", (int)Duration.ofHours(2L).getSeconds()).intValue();
    }

    @Override
    public void validate() throws ConnectorValidationException {
        if (this.sapConnectionIdentifier == null || this.sapConnectionIdentifier.isEmpty()) {
            throw new ConnectorValidationException("No SAP connection selected.");
        }
        ConnectorUtils.validateAndReturnPatterns(this.abapContentExclude, (String)ABAP_CONTENT_EXCLUDE_PARAMETER_NAME);
        ConnectorUtils.validateAndReturnPattern((String)this.modificationsSystemIdsRegex, (String)MODIFICATIONS_SYSTEM_IDS_REGEX_PARAMETER_NAME);
        ConnectorUtils.validateAndReturnPatterns(this.abapTextFilter, (String)ABAP_TEXT_FILTER_PARAMETER_NAME);
        super.validate();
    }

    public String getName() {
        return ERepositoryConnector.ABAP_GIT.getReadableName();
    }

    @Override
    public URI getRepositoryUri() throws StorageException {
        ServerOptionIndex optionIndex = (ServerOptionIndex)this.getContext().getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
        return AbapRepositoryConnectorDescriptor.getGitDirPath(this.sapConnectionIdentifier.getConnectionIdentifier(), optionIndex);
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return AbapChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return AbapContentUpdater.class;
    }

    @Override
    protected boolean validateRevision(String revision) {
        return GitRefUtils.isCommitHashOrHeadRef((String)revision);
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        GitRepositoryConnectorDescriptor.createGitRepositoryIndices(indexCreator, this.repositoryIdentifier);
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        GitRepositoryConnectorDescriptor.setCommonParametersForGitConnectors(triggerBuilder, this.repositoryIdentifier);
        triggerBuilder.setTriggerParameter("sap-connection-identifier", this.getSapConnectionIdentifier());
        String metadataIncludePattern = "**.metadata";
        if (!this.codeIncludePatterns.contains(metadataIncludePattern)) {
            this.codeIncludePatterns.add(metadataIncludePattern);
        }
        this.addPreCommitIncludePattern(ELanguage.ABAP.getFileExtensions());
        this.addPreCommitIncludePattern(ELanguage.ABAP_DDIC.getFileExtensions());
        this.addPreCommitIncludePattern(ELanguage.ABAP_CDS.getFileExtensions());
        super.setCommonParameters(triggerBuilder, triggerCreator);
    }

    private void addPreCommitIncludePattern(String[] fileExtensions) {
        String preCommitIncludePatternPrefix = "$PRECOMMIT/**";
        for (String fileExtension : fileExtensions) {
            String preCommitIncludePattern = preCommitIncludePatternPrefix + "." + fileExtension;
            if (this.codeIncludePatterns.contains(preCommitIncludePattern)) continue;
            this.codeIncludePatterns.add(preCommitIncludePattern);
        }
    }

    @Override
    protected void setContentUpdaterParameters(TriggerBuilder trigger, Collection<ELanguage> configuredLanguages) {
        this.textFilter.addAll(this.abapTextFilter);
        this.contentExclude.addAll(GENERATED_CODE_PATTERNS);
        this.contentExclude.addAll(this.abapContentExclude);
        this.encodingName = AbapUtils.ABAP_ENCODING.name();
        trigger.setTriggerParameter("abap-modifications-system-id", this.modificationsSystemIdsRegex);
        super.setContentUpdaterParameters(trigger, configuredLanguages);
    }

    private String getSapConnectionIdentifier() {
        return this.sapConnectionIdentifier.getConnectionIdentifier();
    }

    @TestOnly
    public void setSapConnectionIdentifierForTesting(SapSystemConnection sapSystemConnection) {
        this.sapConnectionIdentifier = sapSystemConnection;
    }

    @TestOnly
    public void addAbapTextFilter(List<String> abapTextFilter) {
        this.abapTextFilter.addAll(abapTextFilter);
    }

    @TestOnly
    public void addAbapContentExclude(List<String> abapContentExclude) {
        this.abapContentExclude.addAll(abapContentExclude);
    }

    @TestOnly
    public void setModificationsSystemIdsRegex(String modificationsSystemIdsRegex) {
        this.modificationsSystemIdsRegex = modificationsSystemIdsRegex;
    }

    public static URI getGitDirPath(String sapConnectionIdentifier, ServerOptionIndex optionIndex) throws StorageException {
        Path localClonePath = RepositoryCloneOption.getRepositoryCloneDirectory((ServerOptionIndex)optionIndex).resolve(Path.of("sap.abap.system", sapConnectionIdentifier, "git"));
        return localClonePath.toUri();
    }

    @Override
    protected boolean hasPreselectedUIBranchBeforeBranchTransformationUnlikeDefaultBranch(String preselectedUIBranchBeforeTransform) {
        return false;
    }
}

