/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.clones;

import com.teamscale.index.simulink.clones.SimulinkCloneFragment;
import com.teamscale.index.utils.StringPoolDeserializer;
import com.teamscale.index.utils.StringPoolSerializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="inverted-simulink-clone-fragments", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED}, valueClasses={SimulinkCloneFragment.class})
public class InvertedSimulinkCloneFragmentIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "inverted-simulink-clone-fragments";

    public InvertedSimulinkCloneFragmentIndex(IStore store) {
        super(store);
    }

    public List<List<SimulinkCloneFragment>> getFragmentLists(List<Long> hashes) throws StorageException {
        List values = this.store.get(CollectionUtils.map(hashes, ByteArrayUtils::longToByteArray));
        ArrayList<List<SimulinkCloneFragment>> result = new ArrayList<List<SimulinkCloneFragment>>();
        for (int i = 0; i < hashes.size(); ++i) {
            result.add(InvertedSimulinkCloneFragmentIndex.deserializeFragments(hashes.get(i), (byte[])values.get(i)));
        }
        return result;
    }

    public void updateFragmentLists(List<Long> hashes, List<List<SimulinkCloneFragment>> fragments) throws StorageException {
        CCSMAssert.isTrue((hashes.size() == fragments.size() ? 1 : 0) != 0, (String)"Hashes and fragments must have same size!");
        ArrayList<byte[]> toDelete = new ArrayList<byte[]>();
        PairList toAdd = new PairList();
        for (int i = 0; i < hashes.size(); ++i) {
            byte[] key = ByteArrayUtils.longToByteArray((long)hashes.get(i));
            if (CollectionUtils.isNullOrEmpty((Collection)fragments.get(i))) {
                toDelete.add(key);
                continue;
            }
            toAdd.add((Object)key, (Object)InvertedSimulinkCloneFragmentIndex.serializeFragments(fragments.get(i)));
        }
        if (!toDelete.isEmpty()) {
            this.store.remove(toDelete);
        }
        if (!toAdd.isEmpty()) {
            this.store.put(toAdd);
        }
    }

    public void deleteFragmentLists(List<Long> keys) throws StorageException {
        if (!keys.isEmpty()) {
            this.store.remove(keys.stream().map(ByteArrayUtils::longToByteArray).toList());
        }
    }

    private static byte[] serializeFragments(final List<SimulinkCloneFragment> fragments) {
        fragments.sort(Comparator.comparing(SimulinkCloneFragment::getUniformPath).thenComparing(SimulinkCloneFragment::getParentId));
        StringPoolSerializer serializer = new StringPoolSerializer(){

            @Override
            protected void serializeData(DataOutputStream dos) throws IOException {
                dos.writeInt(fragments.size());
                for (SimulinkCloneFragment fragment : fragments) {
                    this.writeString(fragment.getUniformPath(), dos);
                    this.writeString(fragment.getParentId(), dos);
                    List<String> blockNames = fragment.getBlockNames();
                    dos.writeByte(blockNames.size());
                    for (String blockName : blockNames) {
                        this.writeString(blockName, dos);
                    }
                }
            }
        };
        for (SimulinkCloneFragment fragment : fragments) {
            serializer.addString(fragment.getUniformPath());
            serializer.addString(fragment.getParentId());
            fragment.getBlockNames().forEach(serializer::addString);
        }
        return serializer.serialize();
    }

    private static List<SimulinkCloneFragment> deserializeFragments(final long hash, byte[] data) {
        final ArrayList<SimulinkCloneFragment> result = new ArrayList<SimulinkCloneFragment>();
        if (data == null) {
            return result;
        }
        new StringPoolDeserializer(){

            @Override
            protected void deserializeData(DataInputStream din) throws IOException {
                int size = din.readInt();
                for (int i = 0; i < size; ++i) {
                    String uniformPath = this.readString(din);
                    String parentId = this.readString(din);
                    int blockCount = din.readByte();
                    ArrayList<String> blockNames = new ArrayList<String>();
                    for (int j = 0; j < blockCount; ++j) {
                        blockNames.add(this.readString(din));
                    }
                    result.add(new SimulinkCloneFragment(uniformPath, parentId, blockNames, hash));
                }
            }
        }.deserialize(data);
        return result;
    }
}

