/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import com.teamscale.index.comment_analysis.utils.CommentUtils;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.simulink.tracing.SimulinkPlcCoderTraceIndex;
import com.teamscale.index.simulink.tracing.SimulinkSourceFileMapper;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class PlcCoderSimulinkCodeGenerationSourceFileMapper {
    public static List<SimulinkSourceFileMapper.TracingBeacon> generateTracingBeaconsForPlcCoder(TokenElementInfo sourceElement, SimulinkPlcCoderTraceIndex plcCoderTraceIndex) throws StorageException {
        PairList<String, QualifiedNameLocation> plcCoderTraceLinks = plcCoderTraceIndex.getAllTraces();
        if (plcCoderTraceLinks.isEmpty()) {
            return Collections.emptyList();
        }
        PairList tracingCommentsToTargetLocationsMap = new PairList();
        List<IToken> commentTokens = CommentUtils.getCommentTokens(sourceElement.getTokens());
        for (IToken comment : commentTokens) {
            List targetLocations = plcCoderTraceLinks.filter((tag, location) -> comment.getText().contains((CharSequence)tag)).stream().map(ImmutablePair::getSecond).collect(Collectors.toList());
            if (targetLocations.isEmpty()) continue;
            tracingCommentsToTargetLocationsMap.add((Object)comment, targetLocations);
        }
        List tracingRelevantComments = tracingCommentsToTargetLocationsMap.extractFirstList();
        ArrayList<SimulinkSourceFileMapper.TracingBeacon> beaconsInSourceFile = new ArrayList<SimulinkSourceFileMapper.TracingBeacon>();
        UnmodifiableList<ShallowEntity> entities = sourceElement.getShallowEntitiesWithoutPreprocessorTokens();
        for (Pair entry : tracingCommentsToTargetLocationsMap) {
            IToken comment = (IToken)entry.getFirst();
            if (PlcCoderSimulinkCodeGenerationSourceFileMapper.isScopeEndComment(comment)) continue;
            int startLine = comment.getLineNumber() + 1;
            int endLine = PlcCoderSimulinkCodeGenerationSourceFileMapper.determineCommentRegionEndLine(comment, entities, tracingRelevantComments);
            beaconsInSourceFile.add(new SimulinkSourceFileMapper.TracingBeacon(startLine, endLine, (List)entry.getSecond()));
        }
        return beaconsInSourceFile;
    }

    private static boolean isScopeEndComment(IToken comment) {
        return comment.getText().startsWith("(* End of ");
    }

    private static int determineCommentRegionEndLine(IToken comment, List<ShallowEntity> entities, List<IToken> commentTokens) {
        Optional nextCodeEntity = ShallowEntityTraversalUtils.findEntityForLine((int)(comment.getLineNumber() + 1), entities, (boolean)true);
        if (nextCodeEntity.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        for (IToken commentToken : commentTokens) {
            if (commentToken.getLineNumber() < ((ShallowEntity)nextCodeEntity.get()).getEndLine()) continue;
            return commentToken.getLineNumber();
        }
        return Integer.MAX_VALUE;
    }
}

