/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.dotnet;

import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.dotnet.ProfilerIdFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Index(name="dot-net-method-mappings", options={EStorageOption.BACKUP, EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.NO_ROLLBACK})
public class DotNetMethodMappingIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "dot-net-method-mappings";
    private static final ISerializer<SourceLocation, byte[]> SERIALIZER = new ISerializer<SourceLocation, byte[]>(){

        /*
         * Enabled aggressive exception aggregation
         */
        public byte @NonNull [] serialize(@NonNull SourceLocation location) throws StorageException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DataOutputStream dos = new DataOutputStream(baos);){
                    dos.writeUTF(location.getUniformPath());
                    dos.writeInt(location.getRegion().getStart());
                    dos.writeInt(location.getRegion().getEnd());
                    dos.flush();
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }

        public @NonNull SourceLocation deserialize(byte @NonNull [] bytes) throws StorageException {
            SourceLocation sourceLocation;
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                String sourceFile = din.readUTF();
                LineBasedRegion region = new LineBasedRegion(din.readInt(), din.readInt());
                sourceLocation = new SourceLocation(region, sourceFile);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        din.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StorageException((Throwable)e);
                }
            }
            din.close();
            return sourceLocation;
        }
    };
    private final ValueIndex<SourceLocation> delegate;
    private final ConvenientStore store;

    public DotNetMethodMappingIndex(IStore store) {
        this.store = new ConvenientStore(store);
        this.delegate = ValueIndex.of((IStore)store, SERIALIZER);
    }

    public List<SourceLocation> getSourceLocations(List<ProfilerIdFeature> features) throws StorageException {
        List keys = CollectionUtils.map(features, feature -> DotNetMethodMappingIndex.createKey(feature.getAssemblyName(), feature.getMethodToken()));
        return this.delegate.getValues(keys);
    }

    private static String createKey(String assemblyName, String methodToken) {
        return assemblyName.toLowerCase() + "#!#" + methodToken;
    }

    public void replaceMappings(String assemblyName, PairList<String, SourceLocation> mappings) throws StorageException {
        HashMap existingValues = new HashMap();
        this.store.scan(DotNetMethodMappingIndex.createKey(assemblyName, ""), (key, value) -> {
            Map map = existingValues;
            synchronized (map) {
                existingValues.put(StringUtils.bytesToString((byte[])key), value);
            }
        });
        PairList valuesToSet = new PairList();
        HashSet keysToRemove = new HashSet(existingValues.keySet());
        for (int i = 0; i < mappings.size(); ++i) {
            String key2 = DotNetMethodMappingIndex.createKey(assemblyName, (String)mappings.getFirst(i));
            keysToRemove.remove(key2);
            byte[] value2 = (byte[])SERIALIZER.serialize((Object)((SourceLocation)mappings.getSecond(i)));
            if (Arrays.equals((byte[])existingValues.get(key2), value2)) continue;
            valuesToSet.add((Object)key2, (Object)value2);
        }
        if (!valuesToSet.isEmpty()) {
            this.store.putWithStrings(valuesToSet);
        }
        if (!keysToRemove.isEmpty()) {
            this.store.removeWithStrings(new ArrayList(keysToRemove));
        }
    }

    public void clearAssemblyInfo(String assemblyName) throws StorageException {
        this.delegate.removeEntriesStartingWith(List.of(DotNetMethodMappingIndex.createKey(assemblyName, "")));
    }

    public PairList<String, SourceLocation> getAllMappings() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public void removeAllMappings() throws StorageException {
        this.delegate.removeAllEntries();
    }

    public void setMappings(PairList<String, SourceLocation> mappings) throws StorageException {
        this.delegate.setValues(mappings);
    }
}

