/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.treemap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.teamscale.index.testgap.treemap.TreeMapNodeBase;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonDeserialize
@IndexValueClass(containedInBackup=true)
public abstract class MethodTreeMapNodeBase
extends TreeMapNodeBase<Void> {
    private static final long serialVersionUID = 1L;
    protected static final String METHOD_NAME_PROPERTY = "methodName";
    @JsonUnwrapped
    protected final OffsetBasedRegion region;
    @JsonProperty(value="methodName")
    protected final String methodName;

    protected MethodTreeMapNodeBase(String uniformPath) {
        this(uniformPath, new OffsetBasedRegion(0, 0), "");
    }

    protected MethodTreeMapNodeBase(String uniformPath, OffsetBasedRegion region, String methodName) {
        super(uniformPath);
        this.region = region;
        this.methodName = methodName;
    }

    @Override
    public String getText() {
        return super.getText() + ":" + this.region.getStart() + "-" + this.region.getEnd() + StringUtils.LINE_SEPARATOR + this.methodName;
    }

    public OffsetBasedRegion getRegion() {
        return this.region;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    protected String getElementName() {
        if (StringUtils.isEmpty((String)this.methodName)) {
            return super.getElementName();
        }
        return this.methodName;
    }
}

