/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.tracking.FindingChurnList;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class FindingChurnCount
extends CommitAssociatedObjectBase {
    private static final long serialVersionUID = 1L;
    private static final String ADDED_FINDINGS_PROPERTY = "addedFindings";
    private static final String FINDINGS_ADDED_IN_BRANCH_PROPERTY = "findingsAddedInBranch";
    private static final String FINDINGS_IN_CHANGED_CODE_PROPERTY = "findingsInChangedCode";
    private static final String REMOVED_FINDINGS_PROPERTY = "removedFindings";
    private static final String FINDINGS_REMOVED_IN_BRANCH_PROPERTY = "findingsRemovedInBranch";
    @JsonProperty(value="addedFindings")
    private final int addedFindings;
    @JsonProperty(value="findingsAddedInBranch")
    private final int findingsAddedInBranch;
    @JsonProperty(value="findingsInChangedCode")
    private final int findingsInChangedCode;
    @JsonProperty(value="removedFindings")
    private final int removedFindings;
    @JsonProperty(value="findingsRemovedInBranch")
    private final int findingsRemovedInBranch;

    @JsonCreator
    public FindingChurnCount(@JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="addedFindings") int addedFindings, @JsonProperty(value="findingsAddedInBranch") int findingsAddedInBranch, @JsonProperty(value="findingsInChangedCode") int findingsInChangedCode, @JsonProperty(value="removedFindings") int removedFindings, @JsonProperty(value="findingsRemovedInBranch") int findingsRemovedInBranch) {
        super(commit);
        this.addedFindings = addedFindings;
        this.findingsAddedInBranch = findingsAddedInBranch;
        this.findingsInChangedCode = findingsInChangedCode;
        this.removedFindings = removedFindings;
        this.findingsRemovedInBranch = findingsRemovedInBranch;
    }

    public FindingChurnCount(FindingChurnList churnList) {
        super(churnList.getCommit());
        this.addedFindings = churnList.getAddedFindings().size();
        this.findingsAddedInBranch = churnList.getFindingsAddedInBranch().size();
        this.findingsInChangedCode = churnList.getFindingsInChangedCode().size();
        this.removedFindings = churnList.getRemovedFindings().size();
        this.findingsRemovedInBranch = churnList.getFindingsRemovedInBranch().size();
    }

    public int getAddedFindings() {
        return this.addedFindings;
    }

    public int getFindingsAddedInBranch() {
        return this.findingsAddedInBranch;
    }

    public int getFindingsInChangedCode() {
        return this.findingsInChangedCode;
    }

    public int getRemovedFindings() {
        return this.removedFindings;
    }

    public int getFindingsRemovedInBranch() {
        return this.findingsRemovedInBranch;
    }

    public boolean hasFindingsChurn() {
        return this.addedFindings + this.findingsAddedInBranch + this.findingsInChangedCode + this.removedFindings + this.findingsRemovedInBranch > 0;
    }

    public String toString() {
        return this.addedFindings + " added, " + this.findingsAddedInBranch + " added in branch, " + this.findingsInChangedCode + " in changed code, " + this.removedFindings + " removed, " + this.findingsRemovedInBranch + " removed in branch @ " + this.getTimestamp();
    }
}

