/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultFindingsProcessor;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@ExportToTypeScript
@Option(id="partition.tracking-groups", name="Partition tracking groups", type=EOptionType.PROJECT, category=EOptionCategory.EXTERNAL_UPLOADS)
@IndexValueClass(containedInBackup=true)
public class PartitionTrackingGroupsOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "partition.tracking-groups";
    public static final String OPTION_NAME = "Partition tracking groups";
    private static final Pattern OPTION_STRING_SYNTAX_PATTERN = Pattern.compile("(\\[[^\\[\\]]+\\] ?)*");
    private static final Pattern OPTION_STRING_SEPARATOR_PATTERN = Pattern.compile("(\\s*\\[|\\])+");
    @JsonProperty(value="partitionTrackingGroups")
    @OptionFieldDescription(name="This setting allows the specification of partition tracking groups. Any finding uploaded to one of the partitions in one single group can be matched to findings in all partitions in the same group. The setting will not be applied retroactively to already processed uploads (except during a reanalysis of the project, which can be triggered manually if desired). Use the following syntax to specify groups: \"[partition1 partition2], [partition3 partition4 partition5]\". Partitions may not appear in more than one of these groups.")
    public String partitionTrackingGroups = "";

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        try {
            PartitionTrackingGroupsOption.parseOptionString(this.partitionTrackingGroups);
            return null;
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    @VisibleForTesting
    static Set<Set<String>> parseOptionString(String optionString) {
        HashSet<Set<String>> partitionTrackingGroupsSet = new HashSet<Set<String>>();
        if (StringUtils.isEmpty((String)optionString)) {
            return partitionTrackingGroupsSet;
        }
        String normalizedOptionString = optionString;
        normalizedOptionString = normalizedOptionString.replace(",", "");
        normalizedOptionString = StringUtils.replaceAll((String)normalizedOptionString, (Pattern)Patterns.WHITESPACE, (String)" ");
        if (!OPTION_STRING_SYNTAX_PATTERN.matcher(normalizedOptionString = normalizedOptionString.trim()).matches()) {
            throw new IllegalArgumentException("Invalid syntax.");
        }
        partitionTrackingGroupsSet.addAll(OPTION_STRING_SEPARATOR_PATTERN.splitAsStream(normalizedOptionString).filter(group -> !StringUtils.isEmpty((String)group)).map(group -> Patterns.SINGLE_WHITESPACE.splitAsStream((CharSequence)group).map(ExternalAnalysisResultFindingsProcessor::makeExternalFindingsPartition).collect(Collectors.toSet())).toList());
        PartitionTrackingGroupsOption.ensureGroupsArePairwiseDisjoint(partitionTrackingGroupsSet);
        return partitionTrackingGroupsSet;
    }

    private static void ensureGroupsArePairwiseDisjoint(Set<Set<String>> partitionTrackingGroupsSet) throws IllegalArgumentException {
        CounterSet partitionCounter = new CounterSet();
        partitionTrackingGroupsSet.forEach(arg_0 -> ((CounterSet)partitionCounter).incAll(arg_0));
        partitionCounter.getKeysByValueDescending().stream().findFirst().ifPresent(partition -> {
            int partitionOccurrenceCount = partitionCounter.getValue(partition);
            if (partitionOccurrenceCount > 1) {
                throw new IllegalArgumentException("Partition \"" + partition.replace("external:", "") + "\" occurs more than once. Please make sure to include each partition in at most one group.");
            }
        });
    }

    public Set<Set<String>> getPartitionTrackingGroups() {
        return PartitionTrackingGroupsOption.parseOptionString(this.partitionTrackingGroups);
    }
}

