/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import java.util.Map;
import java.util.Set;

public final class JsonObject
extends JsonElement {
    private final LinkedTreeMap<String, JsonElement> members = new LinkedTreeMap(false);

    @Override
    public JsonObject deepCopy() {
        JsonObject result2 = new JsonObject();
        for (Map.Entry<String, JsonElement> entry : this.members.entrySet()) {
            result2.add(entry.getKey(), entry.getValue().deepCopy());
        }
        return result2;
    }

    public void add(String property, JsonElement value2) {
        this.members.put(property, value2 == null ? JsonNull.INSTANCE : value2);
    }

    public JsonElement remove(String property) {
        return this.members.remove(property);
    }

    public void addProperty(String property, String value2) {
        this.add(property, value2 == null ? JsonNull.INSTANCE : new JsonPrimitive(value2));
    }

    public void addProperty(String property, Number value2) {
        this.add(property, value2 == null ? JsonNull.INSTANCE : new JsonPrimitive(value2));
    }

    public void addProperty(String property, Boolean value2) {
        this.add(property, value2 == null ? JsonNull.INSTANCE : new JsonPrimitive(value2));
    }

    public void addProperty(String property, Character value2) {
        this.add(property, value2 == null ? JsonNull.INSTANCE : new JsonPrimitive(value2));
    }

    public Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.members.entrySet();
    }

    public Set<String> keySet() {
        return this.members.keySet();
    }

    public int size() {
        return this.members.size();
    }

    public boolean isEmpty() {
        return this.members.size() == 0;
    }

    public boolean has(String memberName) {
        return this.members.containsKey(memberName);
    }

    public JsonElement get(String memberName) {
        return this.members.get(memberName);
    }

    public JsonPrimitive getAsJsonPrimitive(String memberName) {
        return (JsonPrimitive)this.members.get(memberName);
    }

    public JsonArray getAsJsonArray(String memberName) {
        return (JsonArray)this.members.get(memberName);
    }

    public JsonObject getAsJsonObject(String memberName) {
        return (JsonObject)this.members.get(memberName);
    }

    public Map<String, JsonElement> asMap() {
        return this.members;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof JsonObject && ((JsonObject)o).members.equals(this.members);
    }

    public int hashCode() {
        return this.members.hashCode();
    }
}

