/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.ExpandedTypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorBasedTypeSignatureMappingKt {
    @NotNull
    public static final <T> T mapType(@NotNull KotlinType kotlinType, @NotNull JvmTypeFactory<T> factory, @NotNull TypeMappingMode mode, @NotNull TypeMappingConfiguration<? extends T> typeMappingConfiguration2, @Nullable JvmDescriptorTypeWriter<T> descriptorTypeWriter, @NotNull Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> writeGenericType) {
        JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter;
        T jvmType;
        Object builtInType;
        Intrinsics.checkNotNullParameter(kotlinType, "kotlinType");
        Intrinsics.checkNotNullParameter(factory, "factory");
        Intrinsics.checkNotNullParameter(mode, "mode");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration2, "typeMappingConfiguration");
        Intrinsics.checkNotNullParameter(writeGenericType, "writeGenericType");
        KotlinType kotlinType2 = typeMappingConfiguration2.preprocessType(kotlinType);
        if (kotlinType2 != null) {
            KotlinType kotlinType3;
            KotlinType newType = kotlinType3 = kotlinType2;
            boolean bl = false;
            return DescriptorBasedTypeSignatureMappingKt.mapType(newType, factory, mode, typeMappingConfiguration2, descriptorTypeWriter, writeGenericType);
        }
        if (FunctionTypesKt.isSuspendFunctionType(kotlinType)) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType(kotlinType), factory, mode, typeMappingConfiguration2, descriptorTypeWriter, writeGenericType);
        }
        Object object = SimpleClassicTypeSystemContext.INSTANCE;
        SimpleClassicTypeSystemContext $this$mapType_u24lambda_u2d1 = object;
        boolean bl = false;
        kotlinType2 = TypeSignatureMappingKt.mapBuiltInType($this$mapType_u24lambda_u2d1, kotlinType, factory, mode);
        if (kotlinType2 != null) {
            builtInType = object = kotlinType2;
            boolean bl2 = false;
            Object jvmType2 = TypeSignatureMappingKt.boxTypeIfNeeded(factory, builtInType, mode.getNeedPrimitiveBoxing());
            writeGenericType.invoke(kotlinType, jvmType2, mode);
            return (T)jvmType2;
        }
        TypeConstructor constructor = kotlinType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            builtInType = ((IntersectionTypeConstructor)constructor).getAlternativeType();
            Object intersectionType = builtInType == null ? typeMappingConfiguration2.commonSupertype(((IntersectionTypeConstructor)constructor).getSupertypes()) : builtInType;
            return DescriptorBasedTypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)intersectionType), factory, mode, typeMappingConfiguration2, descriptorTypeWriter, writeGenericType);
        }
        Object bl2 = constructor.getDeclarationDescriptor();
        if (bl2 == null) {
            throw new UnsupportedOperationException(Intrinsics.stringPlus("no descriptor for type constructor of ", kotlinType));
        }
        Object descriptor2 = builtInType = bl2;
        if (ErrorUtils.isError((DeclarationDescriptor)descriptor2)) {
            jvmType = factory.createObjectType("error/NonExistentClass");
            typeMappingConfiguration2.processErrorType(kotlinType, (ClassDescriptor)descriptor2);
            bl2 = descriptorTypeWriter;
            if (bl2 != null) {
                ((JvmDescriptorTypeWriter)bl2).writeClass(jvmType);
            }
            return jvmType;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType)) {
            if (kotlinType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = kotlinType.getArguments().get(0);
            KotlinType jvmType2 = memberProjection.getType();
            Intrinsics.checkNotNullExpressionValue(jvmType2, "memberProjection.type");
            KotlinType memberType = jvmType2;
            Object arrayElementType = null;
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = factory.createObjectType("java/lang/Object");
                JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter2 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter2 != null) {
                    JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter3;
                    JvmDescriptorTypeWriter<T> $this$mapType_u24lambda_u2d3 = jvmDescriptorTypeWriter3 = jvmDescriptorTypeWriter2;
                    boolean bl3 = false;
                    $this$mapType_u24lambda_u2d3.writeArrayType();
                    $this$mapType_u24lambda_u2d3.writeClass(arrayElementType);
                    $this$mapType_u24lambda_u2d3.writeArrayEnd();
                }
            } else {
                Object object2 = descriptorTypeWriter;
                if (object2 != null) {
                    ((JvmDescriptorTypeWriter)object2).writeArrayType();
                }
                object2 = memberProjection.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue(object2, "memberProjection.projectionKind");
                arrayElementType = DescriptorBasedTypeSignatureMappingKt.mapType(memberType, factory, mode.toGenericArgumentMode((Variance)((Object)object2), true), typeMappingConfiguration2, descriptorTypeWriter, writeGenericType);
                object2 = descriptorTypeWriter;
                if (object2 != null) {
                    ((JvmDescriptorTypeWriter)object2).writeArrayEnd();
                }
            }
            return factory.createFromString(Intrinsics.stringPlus("[", factory.toString(arrayElementType)));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            Object object3;
            KotlinType expandedType2;
            if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)descriptor2) && !mode.getNeedInlineClassWrapping() && (expandedType2 = (KotlinType)ExpandedTypeUtilsKt.computeExpandedTypeForInlineClass(SimpleClassicTypeSystemContext.INSTANCE, kotlinType)) != null) {
                return DescriptorBasedTypeSignatureMappingKt.mapType(expandedType2, factory, mode.wrapInlineClassesMode(), typeMappingConfiguration2, descriptorTypeWriter, writeGenericType);
            }
            if (mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
                object3 = factory.getJavaLangClassType();
            } else {
                ClassDescriptor arrayElementType = ((ClassDescriptor)descriptor2).getOriginal();
                Intrinsics.checkNotNullExpressionValue(arrayElementType, "descriptor.original");
                jvmDescriptorTypeWriter = typeMappingConfiguration2.getPredefinedTypeForClass(arrayElementType);
                if (jvmDescriptorTypeWriter == null) {
                    boolean bl4 = false;
                    ClassDescriptor enumClassIfEnumEntry = ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY ? (ClassDescriptor)((ClassDescriptor)descriptor2).getContainingDeclaration() : (ClassDescriptor)descriptor2;
                    ClassDescriptor classDescriptor2 = enumClassIfEnumEntry.getOriginal();
                    Intrinsics.checkNotNullExpressionValue(classDescriptor2, "enumClassIfEnumEntry.original");
                    object3 = factory.createObjectType(DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor2, typeMappingConfiguration2));
                } else {
                    object3 = jvmDescriptorTypeWriter;
                }
            }
            jvmType = object3;
            writeGenericType.invoke(kotlinType, jvmType, mode);
            return jvmType;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            jvmDescriptorTypeWriter = TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2);
            Object object4 = FunctionsKt.getDO_NOTHING_3();
            Object type2 = DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)((Object)jvmDescriptorTypeWriter), factory, mode, typeMappingConfiguration2, null, object4);
            jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                object4 = descriptor2.getName();
                Intrinsics.checkNotNullExpressionValue(object4, "descriptor.getName()");
                jvmDescriptorTypeWriter.writeTypeVariable((Name)object4, type2);
            }
            return (T)type2;
        }
        if (descriptor2 instanceof TypeAliasDescriptor && mode.getMapTypeAliases()) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(((TypeAliasDescriptor)descriptor2).getExpandedType(), factory, mode, typeMappingConfiguration2, descriptorTypeWriter, writeGenericType);
        }
        throw new UnsupportedOperationException(Intrinsics.stringPlus("Unknown type ", kotlinType));
    }

    public static /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration2, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration2, jvmDescriptorTypeWriter, function3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (descriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        if (!KotlinBuiltIns.isUnit(kotlinType)) return false;
        KotlinType kotlinType2 = descriptor2.getReturnType();
        Intrinsics.checkNotNull(kotlinType2);
        if (TypeUtils.isNullableType(kotlinType2)) return false;
        if (descriptor2 instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    @NotNull
    public static final String computeInternalName(@NotNull ClassDescriptor klass, @NotNull TypeMappingConfiguration<?> typeMappingConfiguration2) {
        ClassDescriptor classDescriptor22;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration2, "typeMappingConfiguration");
        String string2 = typeMappingConfiguration2.getPredefinedFullInternalNameForClass(klass);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean classDescriptor22 = false;
            return it;
        }
        DeclarationDescriptor declarationDescriptor = klass.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "klass.containingDeclaration");
        DeclarationDescriptor container = declarationDescriptor;
        String it = SpecialNames.safeIdentifier(klass.getName()).getIdentifier();
        Intrinsics.checkNotNullExpressionValue(it, "safeIdentifier(klass.name).identifier");
        String name = it;
        if (container instanceof PackageFragmentDescriptor) {
            String string4;
            FqName fqName2 = ((PackageFragmentDescriptor)container).getFqName();
            if (fqName2.isRoot()) {
                string4 = name;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String classDescriptor22 = fqName2.asString();
                Intrinsics.checkNotNullExpressionValue(classDescriptor22, "fqName.asString()");
                string4 = stringBuilder.append(StringsKt.replace$default(classDescriptor22, '.', '/', false, 4, null)).append('/').append(name).toString();
            }
            return string4;
        }
        ClassDescriptor classDescriptor3 = classDescriptor22 = container instanceof ClassDescriptor ? (ClassDescriptor)container : null;
        if (classDescriptor22 == null) {
            throw new IllegalArgumentException("Unexpected container: " + container + " for " + klass);
        }
        ClassDescriptor containerClass = classDescriptor22;
        String string5 = typeMappingConfiguration2.getPredefinedInternalNameForClass(containerClass);
        String containerInternalName = string5 == null ? DescriptorBasedTypeSignatureMappingKt.computeInternalName(containerClass, typeMappingConfiguration2) : string5;
        return containerInternalName + '$' + name;
    }

    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor2, TypeMappingConfiguration typeMappingConfiguration2, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration2 = TypeMappingConfigurationImpl.INSTANCE;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor2, typeMappingConfiguration2);
    }
}

