/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PathResolver;
import org.jetbrains.kotlin.com.intellij.ide.plugins.RawPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.ide.plugins.ReadModuleContext;
import org.jetbrains.kotlin.com.intellij.ide.plugins.XmlReader;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.platform.util.plugins.DataLoader;
import org.jetbrains.kotlin.com.intellij.util.lang.ZipFilePool;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J2\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J,\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PluginXmlPathResolver;", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PathResolver;", "pluginJarFiles", "", "Ljava/nio/file/Path;", "(Ljava/util/List;)V", "findInJarFiles", "", "readInto", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/RawPluginDescriptor;", "readContext", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/ReadModuleContext;", "dataLoader", "Lorg/jetbrains/kotlin/com/intellij/platform/util/plugins/DataLoader;", "relativePath", "", "includeBase", "loadXIncludeReference", "base", "resolveModuleFile", "path", "resolvePath", "Companion", "intellij.platform.core.impl"})
public final class PluginXmlPathResolver
implements PathResolver {
    private final List<Path> pluginJarFiles;
    @JvmField
    @NotNull
    public static final PathResolver DEFAULT_PATH_RESOLVER;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean loadXIncludeReference(@NotNull RawPluginDescriptor readInto, @NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader, @Nullable String base, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter(readInto, "readInto");
        Intrinsics.checkNotNullParameter(readContext, "readContext");
        Intrinsics.checkNotNullParameter(dataLoader, "dataLoader");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        String path = Companion.toLoadPath$intellij_platform_core_impl(relativePath, base);
        InputStream inputStream = dataLoader.load(path);
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            InputStream it = inputStream2;
            boolean bl3 = false;
            XmlReader.readModuleDescriptor(it, readContext, (PathResolver)this, dataLoader, Companion.getChildBase$intellij_platform_core_impl(base, relativePath), readInto, null);
            return true;
        }
        ReadModuleContext readModuleContext = readContext;
        Object it = dataLoader;
        String string2 = path;
        Object object = Companion.getChildBase$intellij_platform_core_impl(base, relativePath);
        if (this.findInJarFiles(readInto, readModuleContext, (DataLoader)it, string2, (String)object)) {
            return true;
        }
        if (StringsKt.startsWith$default(path, "META-INF/", false, 2, null)) {
            InputStream inputStream3 = PluginXmlPathResolver.class.getClassLoader().getResourceAsStream(path);
            if (inputStream3 != null) {
                object = inputStream3;
                boolean bl = false;
                boolean bl4 = false;
                it = object;
                boolean bl5 = false;
                XmlReader.readModuleDescriptor((InputStream)it, readContext, (PathResolver)this, dataLoader, null, readInto, null);
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public RawPluginDescriptor resolvePath(@NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader, @NotNull String relativePath, @Nullable RawPluginDescriptor readInto) {
        Intrinsics.checkNotNullParameter(readContext, "readContext");
        Intrinsics.checkNotNullParameter(dataLoader, "dataLoader");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        String path = Companion.toLoadPath$intellij_platform_core_impl(relativePath, null);
        InputStream inputStream = dataLoader.load(path);
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            InputStream it = inputStream2;
            boolean bl3 = false;
            return XmlReader.readModuleDescriptor(it, readContext, (PathResolver)this, dataLoader, null, readInto, null);
        }
        RawPluginDescriptor rawPluginDescriptor = readInto;
        if (rawPluginDescriptor == null) {
            rawPluginDescriptor = new RawPluginDescriptor();
        }
        RawPluginDescriptor result2 = rawPluginDescriptor;
        String string2 = null;
        String string3 = path;
        ReadModuleContext readModuleContext = readContext;
        DataLoader dataLoader2 = dataLoader;
        if (this.findInJarFiles(result2, readModuleContext, dataLoader2, string3, string2)) {
            return result2;
        }
        if (StringsKt.startsWith$default(relativePath, "intellij.", false, 2, null)) {
            throw (Throwable)new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader + ')');
        }
        return null;
    }

    @Override
    @NotNull
    public RawPluginDescriptor resolveModuleFile(@NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader, @NotNull String path, @Nullable RawPluginDescriptor readInto) {
        Intrinsics.checkNotNullParameter(readContext, "readContext");
        Intrinsics.checkNotNullParameter(dataLoader, "dataLoader");
        Intrinsics.checkNotNullParameter(path, "path");
        InputStream input = dataLoader.load(path);
        if (input == null) {
            if (Intrinsics.areEqual(path, "intellij.profiler.clion")) {
                RawPluginDescriptor descriptor2 = new RawPluginDescriptor();
                descriptor2.package = "org.jetbrains.kotlin.com.intellij.profiler.clion";
                return descriptor2;
            }
            throw (Throwable)new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader + ", pluginJarFiles=" + CollectionsKt.joinToString$default(this.pluginJarFiles, "\n  ", null, null, 0, null, null, 62, null) + ')');
        }
        return XmlReader.readModuleDescriptor(input, readContext, (PathResolver)this, dataLoader, null, readInto, null);
    }

    private final boolean findInJarFiles(RawPluginDescriptor readInto, ReadModuleContext readContext, DataLoader dataLoader, String relativePath, String includeBase) {
        ZipFilePool pool = dataLoader.getPool();
        for (Path jarFile : this.pluginJarFiles) {
            ZipFilePool.EntryResolver resolver2;
            Object object;
            if (dataLoader.isExcludedFromSubSearch(jarFile)) continue;
            if (pool == null) {
                if (!PluginXmlPathResolver.Companion.loadUsingZipFile(readInto, readContext, this, dataLoader, jarFile, relativePath, includeBase)) continue;
                return true;
            }
            try {
                object = pool.load(jarFile);
            }
            catch (IOException e) {
                Logger.getInstance(PluginXmlPathResolver.class).error("Corrupted jar file: " + jarFile, e);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(object, "try {\n          pool.loa\u2026       continue\n        }");
            InputStream inputStream = resolver2.loadZipEntry(relativePath);
            if (inputStream == null) continue;
            object = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            Object object2 = it;
            Intrinsics.checkNotNullExpressionValue(object2, "it");
            XmlReader.readModuleDescriptor((InputStream)object2, readContext, (PathResolver)this, dataLoader, includeBase, readInto, ((Object)jarFile).toString());
            return true;
        }
        return false;
    }

    public PluginXmlPathResolver(@NotNull List<? extends Path> pluginJarFiles) {
        Intrinsics.checkNotNullParameter(pluginJarFiles, "pluginJarFiles");
        this.pluginJarFiles = pluginJarFiles;
    }

    static {
        Companion = new Companion(null);
        List list2 = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list2, "Collections.emptyList()");
        DEFAULT_PATH_RESOLVER = new PluginXmlPathResolver(list2);
    }

    @Override
    public boolean isFlat() {
        return PathResolver.DefaultImpls.isFlat(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\tJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\fJB\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0002J\u001f\u0010\u0019\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u001aR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PluginXmlPathResolver$Companion;", "", "()V", "DEFAULT_PATH_RESOLVER", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PathResolver;", "getChildBase", "", "base", "relativePath", "getChildBase$intellij_platform_core_impl", "getParentPath", "path", "getParentPath$intellij_platform_core_impl", "loadUsingZipFile", "", "readInto", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/RawPluginDescriptor;", "readContext", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/ReadModuleContext;", "pathResolver", "dataLoader", "Lorg/jetbrains/kotlin/com/intellij/platform/util/plugins/DataLoader;", "jarFile", "Ljava/nio/file/Path;", "includeBase", "toLoadPath", "toLoadPath$intellij_platform_core_impl", "intellij.platform.core.impl"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean loadUsingZipFile(RawPluginDescriptor readInto, ReadModuleContext readContext, PathResolver pathResolver, DataLoader dataLoader, Path jarFile, String relativePath, String includeBase) {
            try (ZipFile zipFile = new ZipFile(jarFile.toFile());){
                ZipEntry zipEntry;
                String string2;
                if (StringsKt.startsWith$default(relativePath, "/", false, 2, null)) {
                    String string3 = relativePath;
                    int n = 1;
                    boolean bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n);
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).substring(startIndex)");
                } else {
                    string2 = relativePath;
                }
                if (zipFile.getEntry(string2) == null) {
                    boolean bl = false;
                    return bl;
                }
                ZipEntry entry = zipEntry;
                InputStream inputStream = zipFile.getInputStream(entry);
                Intrinsics.checkNotNullExpressionValue(inputStream, "zipFile.getInputStream(entry)");
                XmlReader.readModuleDescriptor(inputStream, readContext, pathResolver, dataLoader, includeBase, readInto, ((Object)jarFile).toString());
                boolean bl = true;
                return bl;
            }
        }

        @NotNull
        public final String toLoadPath$intellij_platform_core_impl(@NotNull String relativePath, @Nullable String base) {
            String string2;
            Intrinsics.checkNotNullParameter(relativePath, "relativePath");
            if (relativePath.charAt(0) == '/') {
                String string3 = relativePath;
                int n = 1;
                boolean bl = false;
                String string4 = string3.substring(n);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
            } else {
                string2 = StringsKt.startsWith$default(relativePath, "intellij.", false, 2, null) ? relativePath : (base == null ? "META-INF/" + relativePath : base + '/' + relativePath);
            }
            return string2;
        }

        @Nullable
        public final String getChildBase$intellij_platform_core_impl(@Nullable String base, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter(relativePath, "relativePath");
            int end = StringsKt.lastIndexOf$default((CharSequence)relativePath, '/', 0, false, 6, null);
            if (end <= 0 || StringsKt.startsWith$default(relativePath, "/META-INF/", false, 2, null)) {
                return base;
            }
            String string2 = relativePath;
            int n = 0;
            boolean bl = false;
            String string3 = string2.substring(n, end);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String childBase = string3;
            return base == null ? childBase : base + '/' + childBase;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

